/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519.java;

import org.whispersystems.curve25519.java.fe_cmov;
import org.whispersystems.curve25519.java.fe_copy;
import org.whispersystems.curve25519.java.fe_neg;
import org.whispersystems.curve25519.java.ge_madd;
import org.whispersystems.curve25519.java.ge_p1p1;
import org.whispersystems.curve25519.java.ge_p1p1_to_p2;
import org.whispersystems.curve25519.java.ge_p1p1_to_p3;
import org.whispersystems.curve25519.java.ge_p2;
import org.whispersystems.curve25519.java.ge_p2_dbl;
import org.whispersystems.curve25519.java.ge_p3;
import org.whispersystems.curve25519.java.ge_p3_0;
import org.whispersystems.curve25519.java.ge_p3_dbl;
import org.whispersystems.curve25519.java.ge_precomp;
import org.whispersystems.curve25519.java.ge_precomp_0;
import org.whispersystems.curve25519.java.ge_precomp_base_0_7;
import org.whispersystems.curve25519.java.ge_precomp_base_16_23;
import org.whispersystems.curve25519.java.ge_precomp_base_24_31;
import org.whispersystems.curve25519.java.ge_precomp_base_8_15;

public class ge_scalarmult_base {
    static int equal(byte b, byte c) {
        int y = b ^ c;
        --y;
        return y >>>= 31;
    }

    static byte negative(byte b) {
        return (byte)(b >> 7 & 1);
    }

    static void cmov(ge_precomp t, ge_precomp u, int b) {
        fe_cmov.fe_cmov(t.yplusx, u.yplusx, b);
        fe_cmov.fe_cmov(t.yminusx, u.yminusx, b);
        fe_cmov.fe_cmov(t.xy2d, u.xy2d, b);
    }

    static void select(ge_precomp t, int pos, byte b) {
        ge_precomp[][] base = pos <= 7 ? ge_precomp_base_0_7.base : (pos <= 15 ? ge_precomp_base_8_15.base : (pos <= 23 ? ge_precomp_base_16_23.base : ge_precomp_base_24_31.base));
        ge_precomp minust = new ge_precomp();
        byte bnegative = ge_scalarmult_base.negative(b);
        byte babs = (byte)(b - ((-bnegative & b) << 1));
        ge_precomp_0.ge_precomp_0(t);
        ge_scalarmult_base.cmov(t, base[pos][0], ge_scalarmult_base.equal(babs, (byte)1));
        ge_scalarmult_base.cmov(t, base[pos][1], ge_scalarmult_base.equal(babs, (byte)2));
        ge_scalarmult_base.cmov(t, base[pos][2], ge_scalarmult_base.equal(babs, (byte)3));
        ge_scalarmult_base.cmov(t, base[pos][3], ge_scalarmult_base.equal(babs, (byte)4));
        ge_scalarmult_base.cmov(t, base[pos][4], ge_scalarmult_base.equal(babs, (byte)5));
        ge_scalarmult_base.cmov(t, base[pos][5], ge_scalarmult_base.equal(babs, (byte)6));
        ge_scalarmult_base.cmov(t, base[pos][6], ge_scalarmult_base.equal(babs, (byte)7));
        ge_scalarmult_base.cmov(t, base[pos][7], ge_scalarmult_base.equal(babs, (byte)8));
        fe_copy.fe_copy(minust.yplusx, t.yminusx);
        fe_copy.fe_copy(minust.yminusx, t.yplusx);
        fe_neg.fe_neg(minust.xy2d, t.xy2d);
        ge_scalarmult_base.cmov(t, minust, bnegative);
    }

    public static void ge_scalarmult_base(ge_p3 h, byte[] a) {
        int i;
        byte[] e = new byte[64];
        ge_p1p1 r = new ge_p1p1();
        ge_p2 s = new ge_p2();
        ge_precomp t = new ge_precomp();
        for (i = 0; i < 32; ++i) {
            e[2 * i] = (byte)(a[i] & 0xF);
            e[2 * i + 1] = (byte)(a[i] >>> 4 & 0xF);
        }
        byte carry = 0;
        i = 0;
        while (i < 63) {
            int n = i;
            e[n] = (byte)(e[n] + carry);
            carry = (byte)(e[i] + 8);
            carry = (byte)(carry >> 4);
            int n2 = i++;
            e[n2] = (byte)(e[n2] - (carry << 4));
        }
        e[63] = (byte)(e[63] + carry);
        ge_p3_0.ge_p3_0(h);
        for (i = 1; i < 64; i += 2) {
            ge_scalarmult_base.select(t, i / 2, e[i]);
            ge_madd.ge_madd(r, h, t);
            ge_p1p1_to_p3.ge_p1p1_to_p3(h, r);
        }
        ge_p3_dbl.ge_p3_dbl(r, h);
        ge_p1p1_to_p2.ge_p1p1_to_p2(s, r);
        ge_p2_dbl.ge_p2_dbl(r, s);
        ge_p1p1_to_p2.ge_p1p1_to_p2(s, r);
        ge_p2_dbl.ge_p2_dbl(r, s);
        ge_p1p1_to_p2.ge_p1p1_to_p2(s, r);
        ge_p2_dbl.ge_p2_dbl(r, s);
        ge_p1p1_to_p3.ge_p1p1_to_p3(h, r);
        for (i = 0; i < 64; i += 2) {
            ge_scalarmult_base.select(t, i / 2, e[i]);
            ge_madd.ge_madd(r, h, t);
            ge_p1p1_to_p3.ge_p1p1_to_p3(h, r);
        }
    }
}

