/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519.java;

import org.whispersystems.curve25519.java.Sha512;
import org.whispersystems.curve25519.java.fe_0;
import org.whispersystems.curve25519.java.fe_1;
import org.whispersystems.curve25519.java.fe_add;
import org.whispersystems.curve25519.java.fe_cmov;
import org.whispersystems.curve25519.java.fe_frombytes;
import org.whispersystems.curve25519.java.fe_invert;
import org.whispersystems.curve25519.java.fe_mont_rhs;
import org.whispersystems.curve25519.java.fe_mul;
import org.whispersystems.curve25519.java.fe_neg;
import org.whispersystems.curve25519.java.fe_pow22523;
import org.whispersystems.curve25519.java.fe_sq;
import org.whispersystems.curve25519.java.fe_sq2;
import org.whispersystems.curve25519.java.fe_tobytes;
import org.whispersystems.curve25519.java.ge_montx_to_p3;
import org.whispersystems.curve25519.java.ge_p3;
import org.whispersystems.curve25519.java.ge_scalarmult_cofactor;

public class elligator {
    public static int legendre_is_nonsquare(int[] in) {
        int[] temp = new int[10];
        byte[] bytes = new byte[32];
        fe_pow22523.fe_pow22523(temp, in);
        fe_sq.fe_sq(temp, temp);
        fe_sq.fe_sq(temp, temp);
        fe_mul.fe_mul(temp, temp, in);
        fe_mul.fe_mul(temp, temp, in);
        fe_tobytes.fe_tobytes(bytes, temp);
        return 1 & bytes[31];
    }

    public static void elligator(int[] u, int[] r) {
        int[] A = new int[10];
        int[] one = new int[10];
        int[] twor2 = new int[10];
        int[] twor2plus1 = new int[10];
        int[] twor2plus1inv = new int[10];
        int[] x = new int[10];
        int[] e = new int[10];
        int[] Atemp = new int[10];
        int[] uneg = new int[10];
        fe_1.fe_1(one);
        fe_0.fe_0(A);
        A[0] = 486662;
        fe_sq2.fe_sq2(twor2, r);
        fe_add.fe_add(twor2plus1, twor2, one);
        fe_invert.fe_invert(twor2plus1inv, twor2plus1);
        fe_mul.fe_mul(x, twor2plus1inv, A);
        fe_neg.fe_neg(x, x);
        fe_mont_rhs.fe_mont_rhs(e, x);
        int nonsquare = elligator.legendre_is_nonsquare(e);
        fe_0.fe_0(Atemp);
        fe_cmov.fe_cmov(Atemp, A, nonsquare);
        fe_add.fe_add(u, x, Atemp);
        fe_neg.fe_neg(uneg, u);
        fe_cmov.fe_cmov(u, uneg, nonsquare);
    }

    public static void hash_to_point(Sha512 sha512provider, ge_p3 p, byte[] in) {
        byte[] hash = new byte[64];
        int[] h = new int[10];
        int[] u = new int[10];
        ge_p3 p3 = new ge_p3();
        sha512provider.calculateDigest(hash, in, in.length);
        byte sign_bit = (byte)((hash[31] & 0x80) >> 7);
        hash[31] = (byte)(hash[31] & 0x7F);
        fe_frombytes.fe_frombytes(h, hash);
        elligator.elligator(u, h);
        ge_montx_to_p3.ge_montx_to_p3(p3, u, sign_bit);
        ge_scalarmult_cofactor.ge_scalarmult_cofactor(p, p3);
    }
}

