/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519;

import com.sun.jna.Library;
import com.sun.jna.Native;
import org.whispersystems.curve25519.Curve25519Provider;
import org.whispersystems.curve25519.JCESecureRandomProvider;
import org.whispersystems.curve25519.NoSuchProviderException;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.curve25519.VrfSignatureVerificationFailedException;

public class NativeCurve25519Provider
implements Curve25519Provider {
    private static Curve25519Library library;
    private static Throwable libraryFailedException;
    private SecureRandomProvider secureRandomProvider = new JCESecureRandomProvider();

    NativeCurve25519Provider() {
        if (libraryFailedException != null) {
            throw new NoSuchProviderException(libraryFailedException);
        }
        try {
            library.smokeCheck(31337);
        }
        catch (UnsatisfiedLinkError ule) {
            throw new NoSuchProviderException(ule);
        }
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public byte[] calculateAgreement(byte[] ourPrivate, byte[] theirPublic) {
        byte[] sharedKey = new byte[32];
        library.calculateAgreement(sharedKey, ourPrivate, theirPublic);
        return sharedKey;
    }

    @Override
    public byte[] generatePublicKey(byte[] privateKey) {
        byte[] publicKey = new byte[32];
        library.generatePublicKey(publicKey, privateKey);
        return publicKey;
    }

    @Override
    public byte[] generatePrivateKey() {
        byte[] privateKey = this.getRandom(32);
        library.generatePrivateKey(privateKey);
        return privateKey;
    }

    @Override
    public byte[] generatePrivateKey(byte[] random) {
        library.generatePrivateKey(random);
        return random;
    }

    @Override
    public byte[] calculateSignature(byte[] random, byte[] privateKey, byte[] message) {
        byte[] signature = new byte[64];
        int result = library.calculateSignature(signature, random, privateKey, message, message.length);
        if (result != 0) {
            System.out.println("Failed");
            throw new AssertionError((Object)"Signature failed!");
        }
        return signature;
    }

    @Override
    public boolean verifySignature(byte[] publicKey, byte[] message, byte[] signature) {
        return library.verifySignature(publicKey, message, message.length, signature) == 0;
    }

    @Override
    public byte[] calculateVrfSignature(byte[] random, byte[] privateKey, byte[] message) {
        byte[] signature = new byte[96];
        int result = library.calculateVrfSignature(signature, random, privateKey, message, message.length);
        if (result != 0) {
            throw new AssertionError((Object)"Signature failed!");
        }
        return signature;
    }

    @Override
    public byte[] verifyVrfSignature(byte[] publicKey, byte[] message, byte[] signature) throws VrfSignatureVerificationFailedException {
        byte[] vrf = new byte[32];
        int result = library.verifyVrfSignature(vrf, publicKey, message, message.length, signature);
        if (result != 0) {
            throw new VrfSignatureVerificationFailedException("Invalid signature");
        }
        return vrf;
    }

    @Override
    public byte[] getRandom(int length) {
        byte[] result = new byte[length];
        this.secureRandomProvider.nextBytes(result);
        return result;
    }

    @Override
    public void setRandomProvider(SecureRandomProvider provider) {
        this.secureRandomProvider = provider;
    }

    static {
        try {
            library = (Curve25519Library)Native.load((String)"curve25519", Curve25519Library.class);
            libraryFailedException = null;
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            library = null;
            libraryFailedException = e;
        }
    }

    public static interface Curve25519Library
    extends Library {
        public void generatePrivateKey(byte[] var1);

        public void generatePublicKey(byte[] var1, byte[] var2);

        public void calculateAgreement(byte[] var1, byte[] var2, byte[] var3);

        public int calculateSignature(byte[] var1, byte[] var2, byte[] var3, byte[] var4, long var5);

        public int verifySignature(byte[] var1, byte[] var2, long var3, byte[] var5);

        public int calculateVrfSignature(byte[] var1, byte[] var2, byte[] var3, byte[] var4, long var5);

        public int verifyVrfSignature(byte[] var1, byte[] var2, byte[] var3, long var4, byte[] var6);

        public int smokeCheck(int var1);
    }
}

