/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.whispersystems.curve25519.java.Sha512;

public class JCESha512Provider
implements Sha512 {
    public static final int SHA512_SIZE = 64;

    @Override
    public void calculateDigest(byte[] out, byte[] in, long length) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(in, 0, (int)length);
            byte[] digest = messageDigest.digest();
            System.arraycopy(digest, 0, out, 0, 64);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void updateDigest(MessageDigest md, byte[] in, long length) {
        md.update(in, 0, (int)length);
    }

    @Override
    public void finishDigest(byte[] out, MessageDigest md) {
        byte[] digest = md.digest();
        System.arraycopy(digest, 0, out, 0, 64);
    }

    @Override
    public MessageDigest initDigest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

