/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519;

import org.whispersystems.curve25519.Curve25519Provider;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.curve25519.VrfSignatureVerificationFailedException;
import org.whispersystems.curve25519.java.Sha512;
import org.whispersystems.curve25519.java.curve_sigs;
import org.whispersystems.curve25519.java.gen_x;
import org.whispersystems.curve25519.java.scalarmult;

abstract class BaseJavaCurve25519Provider
implements Curve25519Provider {
    private final Sha512 sha512provider;
    private SecureRandomProvider secureRandomProvider;

    protected BaseJavaCurve25519Provider(Sha512 sha512provider, SecureRandomProvider secureRandomProvider) {
        this.sha512provider = sha512provider;
        this.secureRandomProvider = secureRandomProvider;
    }

    @Override
    public abstract boolean isNative();

    @Override
    public void setRandomProvider(SecureRandomProvider secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    @Override
    public byte[] calculateAgreement(byte[] ourPrivate, byte[] theirPublic) {
        byte[] agreement = new byte[32];
        scalarmult.crypto_scalarmult(agreement, ourPrivate, theirPublic);
        return agreement;
    }

    @Override
    public byte[] generatePublicKey(byte[] privateKey) {
        byte[] publicKey = new byte[32];
        curve_sigs.curve25519_keygen(publicKey, privateKey);
        return publicKey;
    }

    @Override
    public byte[] generatePrivateKey() {
        byte[] random = this.getRandom(32);
        return this.generatePrivateKey(random);
    }

    @Override
    public byte[] generatePrivateKey(byte[] random) {
        byte[] privateKey = new byte[32];
        System.arraycopy(random, 0, privateKey, 0, 32);
        privateKey[0] = (byte)(privateKey[0] & 0xF8);
        privateKey[31] = (byte)(privateKey[31] & 0x7F);
        privateKey[31] = (byte)(privateKey[31] | 0x40);
        return privateKey;
    }

    @Override
    public byte[] calculateSignature(byte[] random, byte[] privateKey, byte[] message) {
        byte[] result = new byte[64];
        if (curve_sigs.curve25519_sign(this.sha512provider, result, privateKey, message, message.length, random) != 0) {
            throw new IllegalArgumentException("Message exceeds max length!");
        }
        return result;
    }

    @Override
    public boolean verifySignature(byte[] publicKey, byte[] message, byte[] signature) {
        return curve_sigs.curve25519_verify(this.sha512provider, signature, publicKey, message, message.length) == 0;
    }

    @Override
    public byte[] calculateVrfSignature(byte[] random, byte[] privateKey, byte[] message) {
        byte[] result = new byte[96];
        byte[] random32 = new byte[32];
        if (random.length < 32) {
            throw new IllegalArgumentException("too small random");
        }
        System.arraycopy(random, 0, random32, 0, 32);
        if (gen_x.generalized_xveddsa_25519_sign(this.sha512provider, result, privateKey, message, random32)) {
            return result;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte[] verifyVrfSignature(byte[] publicKey, byte[] message, byte[] signature) throws VrfSignatureVerificationFailedException {
        byte[] result = new byte[32];
        if (!gen_x.generalized_xveddsa_25519_verify(this.sha512provider, result, signature, publicKey, message)) {
            throw new VrfSignatureVerificationFailedException();
        }
        return result;
    }

    @Override
    public byte[] getRandom(int length) {
        byte[] result = new byte[length];
        this.secureRandomProvider.nextBytes(result);
        return result;
    }
}

