/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.AbstractMount;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.IOException;

public class VirtualMount
extends AbstractMount {
    AbstractFileFactory<? extends AbstractFile> actualFileFactory;
    VirtualFileFactory virtualFileFactory;
    boolean cached;
    boolean createMountFolder;

    VirtualMount(String mount, String path, VirtualFileFactory virtualFileFactory, AbstractFileFactory<?> actualFileFactory, boolean isDefault, boolean isImaginary, boolean createMountFolder) throws IOException, PermissionDeniedException {
        super(mount, path, isDefault, isImaginary);
        this.actualFileFactory = actualFileFactory;
        this.virtualFileFactory = virtualFileFactory;
        this.createMountFolder = createMountFolder;
        if (!this.isImaginary()) {
            AbstractFile f = actualFileFactory.getFile(path);
            this.path = f.getAbsolutePath();
        }
    }

    public VirtualMount(String mount, String path, VirtualFileFactory virtualFileFactory, AbstractFileFactory<?> actualFileFactory, boolean createMountFolder) throws IOException, PermissionDeniedException {
        this(mount, path, virtualFileFactory, actualFileFactory, false, false, createMountFolder);
    }

    public AbstractFileFactory<? extends AbstractFile> getActualFileFactory() {
        return this.actualFileFactory;
    }

    public String getResolvePath(String path) {
        if (path.length() > FileUtils.addTrailingSlash((String)this.mount).length()) {
            return FileUtils.addTrailingSlash((String)this.path) + path.substring(FileUtils.addTrailingSlash((String)this.mount).length());
        }
        return this.path;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public AbstractFileFactory<VirtualFile> getVirtualFileFactory() {
        return this.virtualFileFactory;
    }

    public boolean isCreateMountFolder() {
        return this.createMountFolder;
    }
}

