/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.UnsupportedChannelException;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.RemoteForwardingFactoryImpl;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.TransportProtocolServer;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ConnectionStateListener;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.SocketListeningForwardingFactoryImpl;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;

public class ConnectionProtocolServer
extends ConnectionProtocol<SshServerContext> {
    TransportProtocolServer transport;

    public ConnectionProtocolServer(TransportProtocolServer transport, String username) {
        super((TransportProtocol)transport, username);
        this.transport = transport;
    }

    protected boolean isClient() {
        return false;
    }

    protected void onStart() {
        SshServerContext context = this.getContext();
        this.con = context.getConnectionManager().registerConnection((ConnectionProtocol)this);
        this.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.transport.getConnection(), new Runnable(){

            @Override
            public void run() {
                for (ConnectionStateListener connectionStateListener : ConnectionProtocolServer.this.getContext().getStateListeners()) {
                    connectionStateListener.connected((SshConnection)ConnectionProtocolServer.this.con);
                }
            }
        }));
    }

    public SshServerContext getContext() {
        return this.transport.getContext();
    }

    public TransportProtocolServer getTransport() {
        return this.transport;
    }

    protected boolean processTCPIPForward(ByteArrayReader bar, ByteArrayWriter response) throws IOException {
        boolean success = false;
        String addressToBind = bar.readString();
        int portToBind = (int)bar.readInt();
        if (this.getContext().getForwardingPolicy().checkInterfacePermitted((SshConnection)this.transport.getConnection(), addressToBind, portToBind)) {
            success = true;
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Forwarding Policy has " + (success ? "authorized" : "denied") + " " + this.username + " remote forwarding access for " + addressToBind + ":" + portToBind), (Object[])new Object[0]);
            }
        }
        if (success) {
            boolean bl = success = this.getContext().getForwardingManager() != null;
            if (success) {
                boolean responseRequired = portToBind == 0;
                try {
                    portToBind = this.getContext().getForwardingManager().startListening(addressToBind, portToBind, this.con, (SocketListeningForwardingFactoryImpl)RemoteForwardingFactoryImpl.INSTANCE);
                    success = true;
                }
                catch (SshException e) {
                    success = false;
                }
                if (responseRequired) {
                    response.writeInt(portToBind);
                }
            }
        }
        return success;
    }

    protected boolean processTCPIPCancel(ByteArrayReader bar, ByteArrayWriter msg) throws IOException {
        String addressToBind = bar.readString();
        int portToBind = (int)bar.readInt();
        boolean success = this.getContext().getForwardingManager().stopListening(addressToBind, portToBind, this.getContext().getRemoteForwardingCancelKillsTunnels(), this.con);
        msg.writeInt(portToBind);
        return success;
    }

    public String getName() {
        return "ssh-connection";
    }

    protected ChannelNG<SshServerContext> createChannel(String channeltype, Connection<SshServerContext> con) throws UnsupportedChannelException, PermissionDeniedException, ChannelOpenException {
        return this.getContext().getChannelFactory().createChannel(channeltype, con);
    }

    protected void onStop() {
    }
}

