/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

public class ChannelDataWindow {
    int maximumWindowSpace;
    int minimumWindowSpace;
    int maximumPacketSize;
    int windowSpace;

    public ChannelDataWindow(int initialWindowSpace, int maximumWindowSpace, int minimumWindowSpace, int maximumPacketSize) {
        this.maximumWindowSpace = maximumWindowSpace;
        this.minimumWindowSpace = minimumWindowSpace;
        this.maximumPacketSize = maximumPacketSize;
        this.windowSpace = initialWindowSpace;
    }

    public synchronized void consume(int count) {
        this.windowSpace -= count;
    }

    public synchronized void adjust(int count) {
        this.windowSpace += count;
        this.notifyAll();
    }

    public synchronized int getWindowSpace() {
        return this.windowSpace;
    }

    public synchronized boolean isAdjustRequired() {
        return this.windowSpace < this.minimumWindowSpace;
    }

    public synchronized int getAdjustCount() {
        return this.maximumWindowSpace - this.windowSpace;
    }

    public synchronized int getMaximumWindowSpace() {
        return this.maximumWindowSpace;
    }

    public synchronized void setMaximumWindowSpace(int maximumWindowSpace) {
        this.maximumWindowSpace = maximumWindowSpace;
    }

    public synchronized int getMinimumWindowSpace() {
        return this.minimumWindowSpace;
    }

    public synchronized void setMinimumWindowSpace(int minimumWindowSpace) {
        this.minimumWindowSpace = minimumWindowSpace;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaxiumPacketSize(int maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    public synchronized void close() {
        this.notifyAll();
    }
}

