/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public class UploadFileContentTask
extends Task {
    Connection<SshClientContext> con;
    String path;
    String content;
    String encoding;

    public UploadFileContentTask(SshClient ssh, String content, String encoding, String path) {
        this(ssh.getConnection(), content, encoding, path);
    }

    public UploadFileContentTask(Connection<SshClientContext> con, String content, String encoding, String path) {
        super((SshConnection)con);
        this.con = con;
        this.path = path;
        this.encoding = encoding;
        this.content = content;
    }

    public void doTask() {
        SftpClientTask task = new SftpClientTask((SshConnection)this.con){

            @Override
            protected void doSftp() {
                try {
                    this.put(new ByteArrayInputStream(UploadFileContentTask.this.content.getBytes(UploadFileContentTask.this.encoding)), UploadFileContentTask.this.path);
                }
                catch (TransferCancelledException | SftpStatusException | SshException | UnsupportedEncodingException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
        try {
            this.con.addTask((ConnectionAwareTask)new ConnectionTaskWrapper(this.con, (Runnable)task));
            task.waitForever();
        }
        catch (Throwable throwable) {
            this.done(task.isDone() && task.isSuccess());
            throw throwable;
        }
        this.done(task.isDone() && task.isSuccess());
    }
}

