/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.util.ByteArrayWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AbstractDigest
implements Digest {
    MessageDigest digest;
    String jceAlgorithm;

    public AbstractDigest(String jceAlgorithm) throws NoSuchAlgorithmException {
        this.digest = JCEProvider.getProviderForAlgorithm(jceAlgorithm) == null ? MessageDigest.getInstance(jceAlgorithm) : MessageDigest.getInstance(jceAlgorithm, JCEProvider.getProviderForAlgorithm(jceAlgorithm));
    }

    @Override
    public byte[] doFinal() {
        return this.digest.digest();
    }

    @Override
    public void putBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        this.putInt(data.length);
        this.putBytes(data);
    }

    @Override
    public void putByte(byte b) {
        this.digest.update(b);
    }

    @Override
    public void putBytes(byte[] data) {
        this.digest.update(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int offset, int len) {
        this.digest.update(data, offset, len);
    }

    @Override
    public void putInt(int i) {
        this.putBytes(ByteArrayWriter.encodeInt((int)i));
    }

    @Override
    public void putString(String str) {
        this.putInt(str.length());
        this.putBytes(str.getBytes());
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    public String getProvider() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.getProvider().getName();
    }
}

