/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshDsaPublicKey;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.jce.AES256Cbc;
import com.sshtools.common.util.Base64;
import com.sshtools.common.util.ByteArrayReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;

class PuTTYPrivateKeyFile
implements SshPrivateKeyFile {
    byte[] formattedKey;

    PuTTYPrivateKeyFile(byte[] formattedKey) throws IOException {
        if (!PuTTYPrivateKeyFile.isFormatted(formattedKey)) {
            throw new IOException("Key is not formatted in the PuTTY key format!");
        }
        this.formattedKey = formattedKey;
    }

    @Override
    public boolean supportsPassphraseChange() {
        return false;
    }

    @Override
    public String getType() {
        return "PuTTY";
    }

    @Override
    public boolean isPassphraseProtected() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.formattedKey)));
        try {
            String encryption;
            String line = reader.readLine();
            if (line != null && (line.startsWith("PuTTY-User-Key-File-2:") || line.equals("PuTTY-User-Key-File-1:")) && (line = reader.readLine()) != null && line.startsWith("Encryption:") && (encryption = line.substring(line.indexOf(":") + 1).trim()).equals("aes256-cbc")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFormatted(byte[] formattedKey) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formattedKey)));
        try {
            String line = reader.readLine();
            return line != null && (line.startsWith("PuTTY-User-Key-File-2:") || line.equals("PuTTY-User-Key-File-1:"));
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SshKeyPair toKeyPair(String passphrase) throws IOException, InvalidPassphraseException {
        boolean wasEncrpyted;
        block21: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.formattedKey)));
            wasEncrpyted = false;
            try {
                String line = reader.readLine();
                if (line == null || !line.startsWith("PuTTY-User-Key-File-2:") && !line.equals("PuTTY-User-Key-File-1:")) break block21;
                int format = line.startsWith("PuTTY-User-Key-File-2:") ? 2 : 1;
                String type = line.substring(line.indexOf(":") + 1).trim();
                line = reader.readLine();
                if (line == null || !line.startsWith("Encryption:")) break block21;
                String encryption = line.substring(line.indexOf(":") + 1).trim();
                line = reader.readLine();
                if (line == null || !line.startsWith("Comment:") || (line = reader.readLine()) == null || !line.startsWith("Public-Lines:")) break block21;
                try {
                    int publiclines = Integer.parseInt(line.substring(line.indexOf(":") + 1).trim());
                    String publickey = "";
                    for (int i = 0; i < publiclines; ++i) {
                        line = reader.readLine();
                        if (line == null) throw new IOException("Corrupt public key data in PuTTY private key");
                        publickey = publickey + line;
                    }
                    try (ByteArrayReader pub = new ByteArrayReader(Base64.decode((String)publickey));){
                        line = reader.readLine();
                        if (line != null && line.startsWith("Private-Lines:")) {
                            int privatelines = Integer.parseInt(line.substring(line.indexOf(":") + 1).trim());
                            String privatekey = "";
                            for (int i = 0; i < privatelines; ++i) {
                                line = reader.readLine();
                                if (line == null) throw new IOException("Corrupt private key data in PuTTY private key");
                                privatekey = privatekey + line;
                            }
                            byte[] blob = Base64.decode((String)privatekey);
                            if (encryption.equals("aes256-cbc")) {
                                AES256Cbc cipher = new AES256Cbc();
                                byte[] iv = new byte[40];
                                byte[] key = new byte[40];
                                Digest hash = ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
                                hash.putInt(0);
                                hash.putBytes(passphrase.getBytes());
                                byte[] key1 = hash.doFinal();
                                hash.putInt(1);
                                hash.putBytes(passphrase.getBytes());
                                byte[] key2 = hash.doFinal();
                                System.arraycopy(key1, 0, key, 0, 20);
                                System.arraycopy(key2, 0, key, 20, 20);
                                ((SshCipher)cipher).init(1, iv, key);
                                cipher.transform(blob);
                                wasEncrpyted = true;
                            }
                            try (ByteArrayReader bar = new ByteArrayReader(blob);){
                                if (type.equals("ssh-dss")) {
                                    pub.readString();
                                    BigInteger p = pub.readBigInteger();
                                    BigInteger q = pub.readBigInteger();
                                    BigInteger g = pub.readBigInteger();
                                    BigInteger y = pub.readBigInteger();
                                    BigInteger x = bar.readBigInteger();
                                    if (format == 1) {
                                        // empty if block
                                    }
                                    SshKeyPair pair = new SshKeyPair();
                                    SshDsaPublicKey publ = ComponentManager.getInstance().createDsaPublicKey(p, q, g, y);
                                    pair.setPublicKey(publ);
                                    pair.setPrivateKey(ComponentManager.getInstance().createDsaPrivateKey(p, q, g, x, publ.getY()));
                                    SshKeyPair sshKeyPair = pair;
                                    return sshKeyPair;
                                }
                                if (!type.equals("ssh-rsa")) throw new IOException("Unexpected key type " + type);
                                pub.readString();
                                BigInteger publicExponent = pub.readBigInteger();
                                BigInteger modulus = pub.readBigInteger();
                                BigInteger privateExponent = bar.readBigInteger();
                                SshKeyPair pair = new SshKeyPair();
                                pair.setPublicKey(ComponentManager.getInstance().createRsaPublicKey(modulus, publicExponent));
                                pair.setPrivateKey(ComponentManager.getInstance().createRsaPrivateKey(modulus, privateExponent));
                                SshKeyPair sshKeyPair = pair;
                                return sshKeyPair;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (OutOfMemoryError outOfMemoryError) {}
            }
            catch (Throwable ex) {
                if (wasEncrpyted) break block21;
                throw new IOException("The PuTTY key could not be read! " + ex.getMessage());
            }
        }
        if (!wasEncrpyted) throw new IOException("The PuTTY key could not be read! Invalid format");
        throw new InvalidPassphraseException();
    }

    @Override
    public void changePassphrase(String oldpassphrase, String newpassprase) throws IOException {
        throw new IOException("Changing passphrase is not supported by the PuTTY key format engine");
    }

    @Override
    public byte[] getFormattedKey() throws IOException {
        return this.formattedKey;
    }

    @Override
    public String getComment() {
        return "";
    }
}

