/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.knownhosts;

import com.sshtools.common.knownhosts.HostKeyUpdater;
import com.sshtools.common.knownhosts.HostKeyVerification;
import com.sshtools.common.publickey.OpenSshCertificate;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.util.Base64;
import com.sshtools.common.util.Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KnownHostsKeyVerification
implements HostKeyVerification,
HostKeyUpdater {
    LinkedList<HostFileEntry> entries = new LinkedList();
    Set<KeyEntry> keyEntries = new LinkedHashSet<KeyEntry>();
    Set<KeyEntry> revokedEntries = new LinkedHashSet<KeyEntry>();
    Map<SshPublicKey, List<KeyEntry>> entriesByPublicKey = new HashMap<SshPublicKey, List<KeyEntry>>();
    List<CertAuthorityEntry> certificateAuthorities = new ArrayList<CertAuthorityEntry>();
    private boolean hashHosts = false;
    private boolean useCanonicalHostname = System.getProperty("maverick.knownHosts.enableReverseDNS", "true").equalsIgnoreCase("true");
    private boolean useReverseDNS = System.getProperty("maverick.knownHosts.enableReverseDNS", "true").equalsIgnoreCase("true");
    private static final String HASH_MAGIC = "|1|";
    private static final String HASH_DELIM = "|";
    Pattern nonStandard = Pattern.compile("\\[([^\\]]+)\\]:([\\d]{1,5})");

    public KnownHostsKeyVerification(InputStream in) throws SshException, IOException {
        this.load(in);
    }

    public KnownHostsKeyVerification(String knownhosts) throws SshException, IOException {
        this.load(new ByteArrayInputStream(Utils.getUTF8Bytes((String)knownhosts)));
    }

    public KnownHostsKeyVerification() {
    }

    public synchronized void clear() {
        this.entries.clear();
        this.keyEntries.clear();
        this.revokedEntries.clear();
        this.entriesByPublicKey.clear();
        this.certificateAuthorities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void load(InputStream in) throws SshException, IOException {
        this.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        block17: while (true) {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("")) {
                    this.entries.add(new BlankEntry());
                    continue;
                }
                if (line.startsWith("#")) {
                    this.entries.add(new CommentEntry(line.substring(1)));
                    continue;
                }
                StringTokenizer tokens = new StringTokenizer(line, " ");
                if (!tokens.hasMoreTokens()) {
                    this.entries.add(new InvalidEntry(line));
                    try {
                        this.onInvalidHostEntry(line);
                    }
                    catch (SshException sshException) {}
                    continue;
                }
                String host = (String)tokens.nextElement();
                String marker = "";
                if (host.startsWith("@")) {
                    marker = host;
                    host = (String)tokens.nextElement();
                }
                String algorithm = null;
                try {
                    if (!tokens.hasMoreTokens()) {
                        this.entries.add(new InvalidEntry(line));
                        try {
                            this.onInvalidHostEntry(line);
                            continue block17;
                        }
                        catch (SshException sshException) {
                            continue;
                        }
                    }
                    algorithm = tokens.nextToken();
                    if (this.loadSsh1PublicKey(host, algorithm, tokens, line)) continue block17;
                    if (!tokens.hasMoreTokens()) {
                        this.entries.add(new InvalidEntry(line));
                        try {
                            this.onInvalidHostEntry(line);
                            continue block17;
                        }
                        catch (SshException sshException) {
                            continue;
                        }
                    }
                    SshPublicKey key = SshKeyUtils.getPublicKey(algorithm + " " + tokens.nextToken());
                    StringBuffer comment = new StringBuffer();
                    while (tokens.hasMoreTokens()) {
                        if (comment.length() > 0) {
                            comment.append(" ");
                        }
                        comment.append(tokens.nextToken());
                    }
                    this.loadSsh2PublicKey(host, marker, algorithm, key, comment.toString());
                }
                catch (IOException e) {
                    this.entries.add(new InvalidEntry(line));
                    try {
                        this.onInvalidHostEntry(line);
                    }
                    catch (SshException sshException) {
                        continue;
                    }
                }
                catch (SshException e) {
                    this.entries.add(new InvalidEntry(line));
                    try {
                        this.onInvalidHostEntry(line);
                    }
                    catch (SshException sshException) {
                        continue;
                    }
                }
                continue block17;
                catch (OutOfMemoryError ox) {
                    reader.close();
                    throw new SshException("Error parsing known_hosts file, is your file corrupt?", 17);
                    return;
                }
            }
            break;
        }
        finally {
            reader.close();
            in.close();
        }
    }

    private Set<String> getNames(String host) {
        return new LinkedHashSet<String>(Arrays.asList(host.split(",")));
    }

    private void loadSsh2PublicKey(String host, String marker, String algorithm, SshPublicKey key, String comment) throws SshException {
        KeyEntry entry;
        if (marker.equalsIgnoreCase("@cert-authority")) {
            CertAuthorityEntry e = new CertAuthorityEntry(this.getNames(host), key, comment);
            this.certificateAuthorities.add(e);
            entry = e;
        } else {
            entry = marker.equalsIgnoreCase("@revoked") ? new RevokedEntry(this.getNames(host), new Ssh2KeyEntry(this.getNames(host), key, comment)) : new Ssh2KeyEntry(this.getNames(host), key, comment);
        }
        this.addEntry(entry);
    }

    private void addEntry(KeyEntry entry) {
        if (!this.entriesByPublicKey.containsKey(entry.getKey())) {
            this.entriesByPublicKey.put(entry.getKey(), new ArrayList());
        }
        this.entries.add(entry);
        this.entriesByPublicKey.get(entry.getKey()).add(entry);
        if (entry instanceof KeyEntry) {
            this.keyEntries.add(entry);
        }
        if (entry instanceof RevokedEntry) {
            this.revokedEntries.add(entry);
        }
        this.onHostKeyAdded(this.getNames(entry.getNames()), entry.getKey());
    }

    protected void onHostKeyAdded(Set<String> names, SshPublicKey key) {
    }

    public synchronized void setComment(KeyEntry entry, String comment) {
        if (!this.keyEntries.contains(entry)) {
            throw new IllegalArgumentException("KeyEntry provided is no longer in this known_hosts file.");
        }
        entry.comment = comment;
    }

    private boolean loadSsh1PublicKey(String host, String algorithm, StringTokenizer tokens, String line) throws SshException {
        if (!algorithm.matches("[0-9]+")) {
            return false;
        }
        if (!tokens.hasMoreTokens()) {
            this.entries.add(new InvalidEntry(line));
            try {
                this.onInvalidHostEntry(line);
            }
            catch (SshException sshException) {
                // empty catch block
            }
            return true;
        }
        String e = (String)tokens.nextElement();
        if (!tokens.hasMoreTokens()) {
            this.entries.add(new InvalidEntry(line));
            try {
                this.onInvalidHostEntry(line);
            }
            catch (SshException sshException) {
                // empty catch block
            }
            return true;
        }
        this.entries.add(new Ssh1KeyEntry(line));
        return true;
    }

    public synchronized void setHashHosts(boolean hashHosts) {
        this.hashHosts = hashHosts;
    }

    protected void onInvalidHostEntry(String entry) throws SshException {
    }

    protected void onHostKeyMismatch(String host, List<SshPublicKey> allowedHostKey, SshPublicKey actualHostKey) throws SshException {
    }

    protected void onUnknownHost(String host, SshPublicKey key) throws SshException {
    }

    protected void onRevokedKey(String host, SshPublicKey key) {
    }

    public synchronized void removeEntries(String host) throws SshException {
        ArrayList<KeyEntry> toRemove = new ArrayList<KeyEntry>();
        for (KeyEntry entry : this.getKeyEntries()) {
            if (!entry.matchesHost(host)) continue;
            toRemove.add(entry);
        }
        this.removeEntry(toRemove.toArray(new KeyEntry[0]));
    }

    public synchronized void removeEntries(String ... hosts) throws SshException {
        for (String host : hosts) {
            this.removeEntries(host);
        }
    }

    public synchronized void removeEntries(SshPublicKey key) {
        List<KeyEntry> toRemove = this.entriesByPublicKey.get(key);
        this.removeEntry(toRemove.toArray(new KeyEntry[0]));
    }

    public synchronized void removeEntry(KeyEntry ... keys) {
        List<KeyEntry> toRemove = Arrays.asList(keys);
        this.keyEntries.removeAll(toRemove);
        this.revokedEntries.removeAll(toRemove);
        this.entries.removeAll(toRemove);
        for (Map.Entry<SshPublicKey, List<KeyEntry>> entry : this.entriesByPublicKey.entrySet()) {
            entry.getValue().removeAll(toRemove);
        }
        this.certificateAuthorities.removeAll(toRemove);
        for (KeyEntry entry : keys) {
            this.onHostKeyRemoved(this.getNames(entry.getNames()), entry.getKey());
        }
    }

    protected void onHostKeyRemoved(Set<String> names, SshPublicKey key) {
    }

    public boolean isHostFileWriteable() {
        return true;
    }

    public void allowHost(String host, SshPublicKey key, boolean always) throws SshException {
        this.addEntry(key, "", this.resolveNames(host).toArray(new String[0]));
    }

    public synchronized void addEntry(SshPublicKey key, String comment, String ... names) throws SshException {
        if (this.useHashHosts()) {
            for (String name : names) {
                this.addEntry(new Ssh2KeyEntry(new HashSet<String>(Arrays.asList(this.generateHash(name))), key, comment));
            }
        } else {
            this.addEntry(new Ssh2KeyEntry(new HashSet<String>(Arrays.asList(names)), key, comment));
        }
    }

    @Override
    public synchronized boolean verifyHost(String host, SshPublicKey pk) throws SshException {
        return this.verifyHost(host, pk, true);
    }

    private synchronized boolean verifyHost(String host, SshPublicKey pk, boolean validateUnknown) throws SshException {
        Set<String> resolvedNames = this.resolveNames(host);
        for (KeyEntry keyEntry : this.revokedEntries) {
            if (!keyEntry.validate(pk, resolvedNames.toArray(new String[0]))) continue;
            this.onRevokedKey(host, pk);
            return false;
        }
        if (this.entriesByPublicKey.containsKey(pk)) {
            List<KeyEntry> keys = this.entriesByPublicKey.get(pk);
            for (KeyEntry entry : keys) {
                if (!entry.validate(pk, resolvedNames.toArray(new String[0]))) continue;
                return true;
            }
        }
        if (pk instanceof OpenSshCertificate) {
            for (CertAuthorityEntry certAuthorityEntry : this.certificateAuthorities) {
                if (!certAuthorityEntry.validate(pk, resolvedNames.toArray(new String[0]))) continue;
                return true;
            }
        }
        if (!validateUnknown) {
            return false;
        }
        this.onUnknownHost(host, pk);
        return this.verifyHost(host, pk, false);
    }

    protected Set<String> resolveNames(String host) {
        String fqn = null;
        String ip = null;
        String resolveHost = host;
        LinkedHashSet<String> resolvedNames = new LinkedHashSet<String>();
        resolvedNames.add(host);
        Matcher m = this.nonStandard.matcher(host);
        boolean nonStandardPorts = m.matches();
        if (nonStandardPorts) {
            resolveHost = m.group(1);
        }
        if (this.useCanonicalHostname() || this.useReverseDNS()) {
            try {
                InetAddress addr = InetAddress.getByName(resolveHost);
                if (this.useCanonicalHostname()) {
                    fqn = nonStandardPorts ? String.format("[%s]:%s", addr.getHostName(), m.group(2)) : addr.getHostName();
                    resolvedNames.add(fqn);
                }
                if (this.useReverseDNS()) {
                    ip = nonStandardPorts ? String.format("[%s]:%s", addr.getHostAddress(), m.group(2)) : addr.getHostAddress();
                    resolvedNames.add(ip);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return resolvedNames;
    }

    public boolean useCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    public boolean useReverseDNS() {
        return this.useReverseDNS;
    }

    public boolean useHashHosts() {
        return this.hashHosts;
    }

    private boolean checkHash(String name, String resolvedName) throws SshException {
        SshHmac sha1 = ComponentManager.getInstance().supportedHMacsCS().getInstance("hmac-sha1");
        String hashData = name.substring(HASH_MAGIC.length());
        String hashSalt = hashData.substring(0, hashData.indexOf(HASH_DELIM));
        String hashStr = hashData.substring(hashData.indexOf(HASH_DELIM) + 1);
        byte[] theHash = Base64.decode((String)hashStr);
        sha1.init(Base64.decode((String)hashSalt));
        sha1.update(resolvedName.getBytes());
        byte[] ourHash = sha1.doFinal();
        return Arrays.equals(theHash, ourHash);
    }

    private String generateHash(String host) throws SshException {
        SshHmac sha1 = ComponentManager.getInstance().supportedHMacsCS().getInstance("hmac-sha1");
        byte[] hashSalt = new byte[sha1.getMacLength()];
        ComponentManager.getInstance().getRND().nextBytes(hashSalt);
        sha1.init(hashSalt);
        sha1.update(host.getBytes());
        byte[] theHash = sha1.doFinal();
        return HASH_MAGIC + Base64.encodeBytes((byte[])hashSalt, (boolean)false) + HASH_DELIM + Base64.encodeBytes((byte[])theHash, (boolean)false);
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer("");
        for (HostFileEntry entry : this.entries) {
            buf.append(entry.getFormattedLine());
            buf.append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public void setUseCanonicalHostnames(boolean value) {
        this.useCanonicalHostname = value;
    }

    public void setUseReverseDNS(boolean value) {
        this.useReverseDNS = value;
    }

    public Set<KeyEntry> getKeyEntries() {
        return this.keyEntries;
    }

    @Override
    public boolean isKnownHost(String host, SshPublicKey key) throws SshException {
        return this.verifyHost(host, key, false);
    }

    @Override
    public void updateHostKey(String host, SshPublicKey key) throws SshException {
        KeyEntry existingEntry = null;
        Set<String> names = this.resolveNames(host);
        for (KeyEntry e : this.getKeyEntries()) {
            if (e.isHashedEntry()) {
                if (!e.matchesHash(e.getNames(), names.toArray(new String[0]))) continue;
                existingEntry = e;
                continue;
            }
            if (!e.matchesHost(names.toArray(new String[0]))) continue;
            existingEntry = e;
        }
        if (existingEntry != null) {
            this.removeEntries(host);
        }
        this.addEntry(key, "", names.toArray(new String[0]));
        if (existingEntry != null) {
            this.onHostKeyUpdated(names, key);
        }
    }

    protected void onHostKeyUpdated(Set<String> names, SshPublicKey key) {
    }

    abstract class NonValidatingFileEntry
    extends HostFileEntry {
        NonValidatingFileEntry() {
        }

        @Override
        boolean canValidate() {
            return false;
        }

        @Override
        boolean validate(SshPublicKey key, String ... resolvedNames) throws SshException {
            throw new UnsupportedOperationException();
        }
    }

    public class BlankEntry
    extends NonValidatingFileEntry {
        @Override
        String getFormattedLine() {
            return "";
        }
    }

    public class InvalidEntry
    extends NonValidatingFileEntry {
        String line;

        InvalidEntry(String line) {
            this.line = line;
        }

        @Override
        String getFormattedLine() {
            return this.line;
        }
    }

    public class CommentEntry
    extends NonValidatingFileEntry {
        String comment;

        CommentEntry(String comment) {
            this.comment = comment;
        }

        @Override
        String getFormattedLine() {
            return String.format("#%s", this.comment);
        }
    }

    public class RevokedEntry
    extends KeyEntry {
        KeyEntry revokedEntry;

        RevokedEntry(Set<String> names, KeyEntry revokedEntry) {
            super(names, revokedEntry.getKey(), revokedEntry.getComment());
            this.revokedEntry = revokedEntry;
        }

        @Override
        String getFormattedLine() {
            return String.format("@revoked %s", this.revokedEntry.getFormattedLine());
        }

        @Override
        boolean canValidate() {
            return true;
        }

        @Override
        public final boolean isRevoked() {
            return true;
        }
    }

    public class CertAuthorityEntry
    extends KeyEntry {
        CertAuthorityEntry(Set<String> names, SshPublicKey key, String comment) {
            super(names, key, comment);
        }

        @Override
        String getFormattedLine() {
            try {
                return String.format("@cert-authority %s %s", this.getNames(), SshKeyUtils.getFormattedKey(this.key, this.comment));
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        boolean canValidate() {
            return true;
        }

        @Override
        boolean validate(SshPublicKey key, String ... resolvedNames) throws SshException {
            if (this.matchesHost(resolvedNames) && key instanceof OpenSshCertificate) {
                return ((OpenSshCertificate)key).getSignedBy().equals(this.key);
            }
            return false;
        }

        @Override
        public final boolean isCertAuthority() {
            return true;
        }
    }

    public class Ssh2KeyEntry
    extends KeyEntry {
        boolean hashedEntry;

        Ssh2KeyEntry(Set<String> names, SshPublicKey key, String comment) {
            super(names, key, comment);
            this.hashedEntry = false;
            if (names.size() == 1 && names.iterator().next().startsWith(KnownHostsKeyVerification.HASH_DELIM)) {
                this.hashedEntry = true;
            }
        }

        @Override
        public boolean isHashedEntry() {
            return this.hashedEntry;
        }

        @Override
        String getFormattedLine() {
            try {
                return String.format("%s %s", this.getNames(), SshKeyUtils.getFormattedKey(this.key, this.comment)).trim();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    class Ssh1KeyEntry
    extends HostFileEntry {
        String line;

        Ssh1KeyEntry(String line) {
            this.line = line;
        }

        @Override
        String getFormattedLine() {
            return this.line;
        }

        @Override
        boolean canValidate() {
            return false;
        }

        @Override
        boolean validate(SshPublicKey key, String ... resolvedNames) throws SshException {
            return false;
        }
    }

    public abstract class KeyEntry
    extends HostFileEntry {
        String comment;
        Set<String> names;
        SshPublicKey key;
        boolean hashedEntry;

        KeyEntry(Set<String> names, SshPublicKey key, String comment) {
            this.hashedEntry = false;
            this.names = names;
            this.key = key;
            this.comment = comment;
            if (names.size() == 1 && names.iterator().next().startsWith(KnownHostsKeyVerification.HASH_DELIM)) {
                this.hashedEntry = true;
            }
        }

        public boolean isHashedEntry() {
            return this.hashedEntry;
        }

        public SshPublicKey getKey() {
            return this.key;
        }

        public String getNames() {
            StringBuffer buf = new StringBuffer();
            for (String name : this.names) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(name);
            }
            return buf.toString();
        }

        boolean matchesHash(String name, String ... resolvedNames) throws SshException {
            for (String resolvedName : resolvedNames) {
                if (!KnownHostsKeyVerification.this.checkHash(name, resolvedName)) continue;
                return true;
            }
            return false;
        }

        boolean matchesHost(String ... resolvedNames) throws SshException {
            boolean success = true;
            boolean matched = false;
            for (String name : this.names) {
                if (name.startsWith(KnownHostsKeyVerification.HASH_MAGIC)) {
                    return this.matchesHash(name, resolvedNames);
                }
                if (name.startsWith("!")) {
                    if (!this.matches(name.substring(1), resolvedNames)) continue;
                    success = false;
                    matched = true;
                    continue;
                }
                if (!this.matches(name, resolvedNames)) continue;
                matched = true;
            }
            if (matched) {
                return success;
            }
            return false;
        }

        @Override
        boolean canValidate() {
            return true;
        }

        @Override
        boolean validate(SshPublicKey key, String ... resolvedNames) throws SshException {
            if (this.matchesHost(resolvedNames)) {
                return key.equals(this.key);
            }
            return false;
        }

        boolean matches(String name, String ... resolvedNames) {
            name = name.replace(".", "\\.");
            name = name.replace("[", "\\[");
            if ((name = name.replace("]", "\\]")).contains("*")) {
                name = name.replace("*", ".*");
            }
            if (name.contains("?")) {
                name = name.replace("?", ".");
            }
            for (String resolvedName : resolvedNames) {
                if (!resolvedName.matches(name)) continue;
                return true;
            }
            return false;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isRevoked() {
            return false;
        }

        public boolean isCertAuthority() {
            return false;
        }
    }

    public abstract class HostFileEntry {
        abstract String getFormattedLine();

        abstract boolean canValidate();

        abstract boolean validate(SshPublicKey var1, String ... var2) throws SshException;
    }
}

