/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.command;

import com.sshtools.common.command.ExecutableCommand;
import com.sshtools.common.logger.Log;
import com.sshtools.common.util.IOStreamConnector;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;

public class NativeExecutableCommand
extends ExecutableCommand {
    Process process;
    String[] commandLine;
    String[] env;
    ProcessThread thread;
    int exitValue = Integer.MIN_VALUE;

    @Override
    public void onStart() {
        this.thread.start();
    }

    @Override
    public int getExitCode() {
        return this.exitValue;
    }

    @Override
    public boolean createProcess(String[] commandLine, Map<String, String> environment) {
        if (commandLine.length == 0) {
            return false;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Creating native process: {}", (Object[])new Object[]{commandLine[0]});
        }
        this.commandLine = commandLine;
        Vector<String> tmp = new Vector<String>();
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                tmp.add(entry.getKey().toString() + "=" + entry.getValue().toString());
            }
        }
        this.env = new String[tmp.size()];
        tmp.copyInto(this.env);
        try {
            this.process = Runtime.getRuntime().exec(commandLine, this.env);
            this.thread = new ProcessThread();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void processStdinData(byte[] data) throws IOException {
        block3: {
            try {
                if (this.process != null) {
                    this.process.getOutputStream().write(data);
                    this.process.getOutputStream().flush();
                }
            }
            catch (IOException ex) {
                if (!Log.isDebugEnabled()) break block3;
                Log.debug((String)"Failed to write data into native process", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void kill() {
        this.process.destroy();
    }

    class ProcessThread
    extends Thread {
        IOStreamConnector stdout;
        IOStreamConnector stderr;

        ProcessThread() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.stdout = new IOStreamConnector(NativeExecutableCommand.this.process.getInputStream(), NativeExecutableCommand.this.getOutputStream());
                    this.stderr = new IOStreamConnector(NativeExecutableCommand.this.process.getErrorStream(), NativeExecutableCommand.this.getStderrOutputStream());
                    NativeExecutableCommand.this.exitValue = NativeExecutableCommand.this.process.waitFor();
                }
                catch (Throwable ex) {
                    if (!Log.isDebugEnabled()) break block2;
                    Log.debug((String)"Native process transfer thread failed", (Throwable)ex, (Object[])new Object[0]);
                }
            }
        }
    }
}

