/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.command;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SessionChannelServer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class ExecutableCommand {
    public static final int STILL_ACTIVE = Integer.MIN_VALUE;
    protected SessionChannelServer session;

    public void init(SessionChannelServer session) {
        this.session = session;
        session.haltIncomingData();
    }

    public SessionChannel getSession() {
        return this.session;
    }

    public abstract boolean createProcess(String[] var1, Map<String, String> var2);

    public void start() {
        this.session.getConnection().executeTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutableCommand.this.onStart();
                }
                catch (Throwable e) {
                    Log.error((String)"Consumed error from executable command", (Throwable)e, (Object[])new Object[0]);
                }
            }
        });
    }

    public abstract void onStart();

    public abstract void kill();

    public abstract int getExitCode();

    public OutputStream getOutputStream() {
        return this.session.getOutputStream();
    }

    public OutputStream getStderrOutputStream() {
        return this.session.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, byte[] modes) {
        return false;
    }
}

