/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.auth;

import com.sshtools.common.auth.AbstractPublicKeyAuthenticationProvider;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.publickey.SshPublicKeyFile;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class AuthorizedKeysPublicKeyAuthenticationProvider
extends AbstractPublicKeyAuthenticationProvider {
    protected String authorizedKeysFile = ".ssh/authorized_keys";

    public AuthorizedKeysPublicKeyAuthenticationProvider() {
    }

    public AuthorizedKeysPublicKeyAuthenticationProvider(String authorizedKeysFile) {
        this.authorizedKeysFile = authorizedKeysFile;
    }

    @Override
    public boolean isAuthorizedKey(SshPublicKey key, SshConnection con) {
        try {
            String line;
            AbstractFile file = this.getFile(con);
            InputStream in = file.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            try {
                int read;
                while ((read = in.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, read);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            in.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("") || line.startsWith("#")) continue;
                String[] tokens = line.split(" ");
                StringBuffer keyline = new StringBuffer();
                boolean skip = true;
                for (String t : tokens) {
                    if (skip && JCEComponentManager.getInstance().supportedPublicKeys().contains(t)) {
                        skip = false;
                    }
                    if (skip) continue;
                    if (keyline.length() > 0) {
                        keyline.append(" ");
                    }
                    keyline.append(t);
                }
                SshPublicKeyFile pubfile = SshPublicKeyFileFactory.parse(keyline.toString().getBytes("US-ASCII"));
                if (!pubfile.toPublicKey().equals(key)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SshPublicKey key, String comment, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        AbstractFile file = this.getFile(con);
        SshPublicKeyFile keyFile = null;
        keyFile = SshPublicKeyFileFactory.create(key, comment, 0);
        try (OutputStream out = file.getOutputStream(file.exists());){
            out.write((keyFile.toString() + "\n").getBytes("US-ASCII"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(SshPublicKey key, SshConnection con) throws IOException, PermissionDeniedException, SshException {
        AbstractFile file = this.getFile(con);
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        PrintWriter outWriter = new PrintWriter(outBuffer);
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                SshPublicKeyFile pubfile = SshPublicKeyFileFactory.parse(line.getBytes("US-ASCII"));
                SshPublicKey spk = pubfile.toPublicKey();
                if (spk.getFingerprint().equals(key.getFingerprint())) continue;
                outWriter.println(line);
            }
        }
        finally {
            reader.close();
            outWriter.close();
        }
        try (OutputStream out = file.getOutputStream();){
            out.write(outBuffer.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SshPublicKeyFile> getKeys(SshConnection con) throws PermissionDeniedException, IOException {
        AbstractFile file = this.getFile(con);
        ArrayList<SshPublicKeyFile> keyFiles = new ArrayList<SshPublicKeyFile>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                SshPublicKeyFile pubfile = SshPublicKeyFileFactory.parse(line.getBytes("US-ASCII"));
                keyFiles.add(pubfile);
            }
        }
        return keyFiles.iterator();
    }

    protected AbstractFile getFile(SshConnection con) throws PermissionDeniedException, IOException {
        AbstractFileFactory<?> s = con.getContext().getPolicy(FileSystemPolicy.class).getFileFactory().getFileFactory(con);
        Object file = this.authorizedKeysFile.startsWith("/") ? s.getFile(this.authorizedKeysFile) : s.getDefaultPath().resolveFile(this.authorizedKeysFile);
        return file;
    }

    @Override
    public boolean checkKey(SshPublicKey key, SshConnection con) throws IOException {
        return this.isAuthorizedKey(key, con);
    }
}

