/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.missinglink.maven;

import com.google.common.base.Preconditions;
import com.spotify.missinglink.datamodel.ArtifactName;

public class MavenArtifactName
extends ArtifactName {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public MavenArtifactName(String groupId, String artifactId, String version) {
        super(groupId + ":" + artifactId + ":" + version);
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId);
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId);
        this.version = (String)Preconditions.checkNotNull((Object)version);
    }

    String groupId() {
        return this.groupId;
    }

    String artifactId() {
        return this.artifactId;
    }

    String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenArtifactName that = (MavenArtifactName)((Object)o);
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return "MavenArtifactName{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

