/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions.der;

import com.ripple.cryptoconditions.der.DerTag;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DerOutputStream
extends FilterOutputStream {
    public DerOutputStream(OutputStream out) {
        super(out);
    }

    public void writeLength(int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.write((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                this.write((byte)(length >> i));
            }
        } else {
            this.write((byte)length);
        }
    }

    public void writeEncoded(int tag, byte[] bytes) throws IOException {
        this.write(tag);
        this.writeLength(bytes.length);
        this.write(bytes);
    }

    public void writeTaggedObject(int tagNumber, byte[] object) throws IOException {
        this.writeEncoded(DerTag.TAGGED.getTag() + tagNumber, object);
    }

    public void writeTaggedConstructedObject(int tagNumber, byte[] object) throws IOException {
        this.writeEncoded(DerTag.TAGGED.getTag() + DerTag.CONSTRUCTED.getTag() + tagNumber, object);
    }
}

