/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions.der;

import com.ripple.cryptoconditions.der.DerEncodingException;
import com.ripple.cryptoconditions.der.DerObject;
import com.ripple.cryptoconditions.der.DerTag;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class DerInputStream
extends FilterInputStream {
    public DerInputStream(InputStream in) {
        super(in);
    }

    public DerObject readTaggedConstructedObject(int expectedTagNumber, int limit, AtomicInteger bytesRead) throws IOException, DerEncodingException {
        DerObject object = this.readObject(limit, bytesRead);
        int expectedTag = DerTag.TAGGED.getTag() + DerTag.CONSTRUCTED.getTag() + expectedTagNumber;
        if (object.getTag() != expectedTag) {
            throw new DerEncodingException("Expected tag: " + expectedTag + " but got: " + object.getTag());
        }
        return object;
    }

    public DerObject readTaggedObject(int expectedTagNumber, int limit, AtomicInteger bytesRead) throws IOException, DerEncodingException {
        DerObject object = this.readObject(limit, bytesRead);
        if (object.getTag() != DerTag.TAGGED.getTag() + expectedTagNumber) {
            throw new DerEncodingException("Expected tag: " + Integer.toHexString(DerTag.TAGGED.getTag() + expectedTagNumber) + " but got: " + Integer.toHexString(object.getTag()));
        }
        return object;
    }

    public DerObject readObject(int limit, AtomicInteger bytesRead) throws IOException, DerEncodingException {
        AtomicInteger innerBytesRead = new AtomicInteger(0);
        DerObject obj = new DerObject();
        obj.setTag(this.readTag(innerBytesRead, new DerTag[0]));
        obj.setLength(this.readLength(innerBytesRead));
        if (innerBytesRead.get() + obj.getLength() > limit) {
            throw new DerEncodingException("Object length [" + obj.getLength() + "] is larger than allowed.");
        }
        bytesRead.addAndGet(innerBytesRead.get());
        if (obj.getLength() > 0) {
            obj.setValue(this.readValue(obj.getLength(), bytesRead));
        } else {
            obj.setValue(new byte[0]);
        }
        return obj;
    }

    public int readTag(int expectedTag, AtomicInteger bytesRead, DerTag ... flags) throws DerEncodingException, IOException {
        int tag = this.readTag(bytesRead, flags);
        if (tag != expectedTag) {
            throw new DerEncodingException("Expected tag: " + Integer.toHexString(expectedTag) + ", got: " + Integer.toHexString(tag));
        }
        return tag;
    }

    public int readTag(AtomicInteger bytesRead, DerTag ... expectedFlags) throws DerEncodingException, IOException {
        int tag = this.in.read();
        bytesRead.incrementAndGet();
        if (tag < 0) {
            throw new DerEncodingException("Expected tag, got end of stream.");
        }
        for (DerTag expected : expectedFlags) {
            tag -= expected.getTag();
        }
        if (tag < 0) {
            throw new DerEncodingException("Some flags are missing resulting in a tag value of < 0.");
        }
        return tag;
    }

    public int readLength(AtomicInteger bytesRead) throws DerEncodingException, IOException {
        int lengthOfLength = 1;
        int length = this.in.read();
        bytesRead.incrementAndGet();
        if (length > 127) {
            lengthOfLength = length & 0x7F;
            if (lengthOfLength > 4) {
                throw new DerEncodingException("DER length more than 4 bytes: " + lengthOfLength);
            }
            length = 0;
            for (int i = 0; i < lengthOfLength; ++i) {
                int next = this.in.read();
                bytesRead.incrementAndGet();
                if (next < 0) {
                    throw new DerEncodingException("End of stream found reading length.");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new DerEncodingException("Negative length found: " + length);
            }
        }
        return length;
    }

    public byte[] readValue(int length, AtomicInteger bytesRead) throws IOException, DerEncodingException {
        byte[] buffer = new byte[length];
        if (this.in.read(buffer, 0, length) < length) {
            throw new DerEncodingException("End of stream found reading value.");
        }
        bytesRead.addAndGet(length);
        return buffer;
    }
}

