/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ImmutableThresholdSha256Fulfillment;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public interface ThresholdSha256Fulfillment
extends Fulfillment<ThresholdSha256Condition> {
    public static ThresholdSha256Fulfillment from(List<Condition> subconditions, List<Fulfillment> subfulfillments) {
        Objects.requireNonNull(subconditions, "subconditions must not be null!");
        Objects.requireNonNull(subfulfillments, "subfulfillments must not be null!");
        List<Condition> immutableSubconditions = Collections.unmodifiableList(subconditions.stream().collect(Collectors.toList()));
        List<Fulfillment> immutableFulfillments = Collections.unmodifiableList(subfulfillments.stream().collect(Collectors.toList()));
        ThresholdSha256Condition condition = AbstractThresholdSha256Fulfillment.constructCondition(immutableSubconditions, immutableFulfillments);
        return ImmutableThresholdSha256Fulfillment.builder().type(CryptoConditionType.THRESHOLD_SHA256).subconditions(immutableSubconditions).subfulfillments(immutableFulfillments).derivedCondition(condition).build();
    }

    public List<Condition> getSubconditions();

    public List<Fulfillment> getSubfulfillments();

    @Value.Immutable
    public static abstract class AbstractThresholdSha256Fulfillment
    implements ThresholdSha256Fulfillment {
        static ThresholdSha256Condition constructCondition(List<Condition> subconditions, List<Fulfillment> subfulfillments) {
            Objects.requireNonNull(subconditions);
            Objects.requireNonNull(subfulfillments);
            ArrayList<Condition> allConditions = new ArrayList<Condition>();
            allConditions.addAll(subconditions);
            allConditions.addAll(subfulfillments.stream().map(fulfillment -> fulfillment.getDerivedCondition()).collect(Collectors.toList()));
            return ThresholdSha256Condition.from(subfulfillments.size(), allConditions.stream().collect(Collectors.toList()));
        }

        @Override
        public boolean verify(Condition condition, byte[] message) {
            Objects.requireNonNull(condition, "Can't verify a ThresholdSha256Fulfillment against an null condition.");
            Objects.requireNonNull(message, "Message must not be null!");
            if (!((ThresholdSha256Condition)this.getDerivedCondition()).equals(condition)) {
                return false;
            }
            List<Fulfillment> subfulfillments = this.getSubfulfillments();
            for (int i = 0; i < subfulfillments.size(); ++i) {
                Object subcondition;
                Fulfillment subfulfillment = subfulfillments.get(i);
                if (subfulfillment.verify((Condition)(subcondition = subfulfillment.getDerivedCondition()), message)) continue;
                return false;
            }
            return true;
        }
    }
}

