/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import com.ripple.cryptoconditions.ThresholdSha256Fulfillment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ThresholdFactory {
    public static ThresholdSha256Condition oneOfTwoCondition(Condition condition1, Condition condition2) {
        Objects.requireNonNull(condition1, "condition1 must not be null!");
        Objects.requireNonNull(condition2, "condition2 must not be null!");
        return ThresholdFactory.constructMOfNCondition(1, 2, Stream.of(condition1, condition2).collect(Collectors.toList()));
    }

    public static ThresholdSha256Condition twoOfTwoCondition(Condition condition1, Condition condition2) {
        Objects.requireNonNull(condition1, "condition1 must not be null!");
        Objects.requireNonNull(condition2, "condition2 must not be null!");
        return ThresholdFactory.constructMOfNCondition(2, 2, Stream.of(condition1, condition2).collect(Collectors.toList()));
    }

    public static ThresholdSha256Condition constructMOfNCondition(int thresholdM, int numSubCondtionsN, List<Condition> subconditions) {
        Objects.requireNonNull(subconditions, "subconditions must not be null!");
        if (thresholdM < 0) {
            throw new IllegalArgumentException("Threshold must not be negative!");
        }
        if (subconditions.size() != numSubCondtionsN) {
            throw new IllegalArgumentException(String.format("Number of sub-conditions must equal %d!", numSubCondtionsN));
        }
        return ThresholdSha256Condition.from(thresholdM, subconditions);
    }

    public static ThresholdSha256Fulfillment oneOfTwoFulfillment(Fulfillment fulfillment, Condition condition) {
        Objects.requireNonNull(condition, "condition must not be null!");
        Objects.requireNonNull(fulfillment, "fulfillment must not be null!");
        return ThresholdFactory.constructMOfNFulfillment(1, 2, Collections.singletonList(condition), Collections.singletonList(fulfillment));
    }

    public static ThresholdSha256Fulfillment twoOfTwoFulfillment(Fulfillment fulfillment1, Fulfillment fulfillment2) {
        Objects.requireNonNull(fulfillment1, "fulfillment1 must not be null!");
        Objects.requireNonNull(fulfillment2, "fulfillment2 must not be null!");
        return ThresholdFactory.constructMOfNFulfillment(2, 2, Collections.emptyList(), Stream.of(fulfillment1, fulfillment2).collect(Collectors.toList()));
    }

    public static ThresholdSha256Fulfillment constructMOfNFulfillment(int thresholdM, int totalN, List<Condition> subconditions, List<Fulfillment> subfulfillments) {
        Objects.requireNonNull(subconditions, "subconditions must not be null!");
        Objects.requireNonNull(subfulfillments, "subfulfillments must not be null!");
        if (thresholdM < 0) {
            throw new IllegalArgumentException("thresholdM (Threshold) must not be negative!");
        }
        int computedM = subconditions.size() + subfulfillments.size();
        if (thresholdM > computedM) {
            throw new IllegalArgumentException("Threshold must be less than or equal to the number of sub-fulfillments!");
        }
        if (subconditions.size() + subfulfillments.size() != totalN) {
            throw new IllegalArgumentException(String.format("The combined number of sub-conditions and sub-fulfillments must equal %d!", totalN));
        }
        List<Condition> immutableSubconditions = Collections.unmodifiableList(Stream.concat(subconditions.stream(), subfulfillments.stream().skip(thresholdM).map(Fulfillment::getDerivedCondition)).collect(Collectors.toList()));
        List<Fulfillment> immutableSubFulfillments = Collections.unmodifiableList(subfulfillments.stream().limit(thresholdM).collect(Collectors.toList()));
        return ThresholdSha256Fulfillment.from(immutableSubconditions, immutableSubFulfillments);
    }
}

