/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ImmutableRsaSha256Fulfillment;
import com.ripple.cryptoconditions.RsaSha256Condition;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.immutables.value.Value;

public interface RsaSha256Fulfillment
extends Fulfillment<RsaSha256Condition> {
    public static final BigInteger PUBLIC_EXPONENT = BigInteger.valueOf(65537L);

    public static RsaSha256Fulfillment from(RSAPublicKey publicKey, byte[] signature) {
        Objects.requireNonNull(publicKey, "PublicKey must not be null!");
        Objects.requireNonNull(signature, "Signature must not be null!");
        byte[] immutableSignature = Arrays.copyOf(signature, signature.length);
        String signatureBase64Url = Base64.getUrlEncoder().encodeToString(signature);
        RsaSha256Condition condition = RsaSha256Condition.from(publicKey);
        return ImmutableRsaSha256Fulfillment.builder().type(CryptoConditionType.RSA_SHA256).publicKey(publicKey).signature(immutableSignature).signatureBase64Url(signatureBase64Url).derivedCondition(condition).build();
    }

    public RSAPublicKey getPublicKey();

    @Deprecated
    public byte[] getSignature();

    public String getSignatureBase64Url();

    @Value.Immutable
    public static abstract class AbstractRsaSha256Fulfillment
    implements RsaSha256Fulfillment {
        private static final String SHA_256_WITH_RSA_PSS = "SHA256withRSA/PSS";

        @Override
        public boolean verify(Condition condition, byte[] message) {
            Objects.requireNonNull(condition, "Can't verify a RsaSha256Fulfillment against an null condition.");
            Objects.requireNonNull(message, "Message must not be null!");
            if (!((RsaSha256Condition)this.getDerivedCondition()).equals(condition)) {
                return false;
            }
            try {
                byte[] signatureBytes = Base64.getUrlDecoder().decode(this.getSignatureBase64Url());
                Signature rsaSigner = Signature.getInstance(SHA_256_WITH_RSA_PSS);
                rsaSigner.initVerify(this.getPublicKey());
                rsaSigner.update(message);
                return rsaSigner.verify(signatureBytes);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "RsaSha256Fulfillment{publicKey=" + this.getPublicKey() + ", signature=" + this.getSignatureBase64Url() + ", type=" + (Object)((Object)this.getType()) + ", condition=" + this.getDerivedCondition() + "}";
        }
    }
}

