/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.ConditionBase;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.ImmutableRsaSha256Condition;
import com.ripple.cryptoconditions.RsaSha256Fulfillment;
import com.ripple.cryptoconditions.Sha256Condition;
import com.ripple.cryptoconditions.der.DerOutputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.HashUtils;
import com.ripple.cryptoconditions.utils.UnsignedBigInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Objects;
import org.immutables.value.Value;

public interface RsaSha256Condition
extends Sha256Condition {
    public static RsaSha256Condition from(RSAPublicKey rsaPublicKey) {
        Objects.requireNonNull(rsaPublicKey);
        long cost = AbstractRsaSha256Condition.calculateCost(rsaPublicKey);
        byte[] fingerprint = HashUtils.hashFingerprintContents(AbstractRsaSha256Condition.constructFingerprintContents(rsaPublicKey));
        return ImmutableRsaSha256Condition.builder().type(CryptoConditionType.RSA_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    public static RsaSha256Condition fromCostAndFingerprint(long cost, byte[] fingerprint) {
        Objects.requireNonNull(fingerprint);
        return ImmutableRsaSha256Condition.builder().type(CryptoConditionType.RSA_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    @Value.Immutable
    public static abstract class AbstractRsaSha256Condition
    extends ConditionBase<RsaSha256Condition>
    implements RsaSha256Condition {
        static final byte[] constructFingerprintContents(RSAPublicKey publicKey) {
            Objects.requireNonNull(publicKey);
            AbstractRsaSha256Condition.validatePublicKey(publicKey);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DerOutputStream out = new DerOutputStream(baos);
                out.writeTaggedObject(0, UnsignedBigInteger.toUnsignedByteArray(publicKey.getModulus()));
                out.close();
                byte[] buffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DerOutputStream(baos);
                out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.SEQUENCE.getTag(), buffer);
                out.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException("DER Encoding Error", e);
            }
        }

        static final long calculateCost(RSAPublicKey key) {
            return (long)Math.pow(UnsignedBigInteger.toUnsignedByteArray(key.getModulus()).length, 2.0);
        }

        static final void validatePublicKey(RSAPublicKey publicKey) {
            if (publicKey.getPublicExponent().compareTo(RsaSha256Fulfillment.PUBLIC_EXPONENT) != 0) {
                throw new IllegalArgumentException("Public Exponent from RSA key must be 65537.");
            }
            if (publicKey.getModulus().bitLength() <= 1017 || publicKey.getModulus().bitLength() > 4096) {
                throw new IllegalArgumentException("Modulus from RSA key must be greater than 128 bytes and less than 512 bytes.");
            }
        }

        public String toString() {
            return "RsaSha256Condition{type=" + (Object)((Object)this.getType()) + ", fingerprint=" + this.getFingerprintBase64Url() + ", cost=" + this.getCost() + "}";
        }
    }
}

