/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ImmutablePreimageSha256Fulfillment;
import com.ripple.cryptoconditions.PreimageSha256Condition;
import com.ripple.cryptoconditions.utils.HashUtils;
import java.util.Base64;
import java.util.Objects;
import org.immutables.value.Value;

public interface PreimageSha256Fulfillment
extends Fulfillment<PreimageSha256Condition> {
    public static PreimageSha256Fulfillment from(byte[] preimage) {
        Objects.requireNonNull(preimage);
        String encodedPreimage = Base64.getUrlEncoder().encodeToString(preimage);
        long cost = AbstractPreimageSha256Fulfillment.calculateCost(preimage);
        byte[] fingerprint = HashUtils.hashFingerprintContents(AbstractPreimageSha256Fulfillment.constructFingerprint(preimage));
        PreimageSha256Condition condition = PreimageSha256Condition.fromCostAndFingerprint(cost, fingerprint);
        return ImmutablePreimageSha256Fulfillment.builder().type(CryptoConditionType.PREIMAGE_SHA256).encodedPreimage(encodedPreimage).derivedCondition(condition).build();
    }

    public String getEncodedPreimage();

    @Value.Immutable
    public static abstract class AbstractPreimageSha256Fulfillment
    implements PreimageSha256Fulfillment {
        static byte[] constructFingerprint(byte[] preimage) {
            return Objects.requireNonNull(preimage);
        }

        static long calculateCost(byte[] preimage) {
            return preimage.length;
        }

        @Override
        public final boolean verify(Condition condition, byte[] message) {
            Objects.requireNonNull(condition, "Can't verify a PreimageSha256Fulfillment against an null condition.");
            Objects.requireNonNull(message, "Message must not be null!");
            return ((PreimageSha256Condition)this.getDerivedCondition()).equals(condition);
        }
    }
}

