/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ImmutablePrefixSha256Fulfillment;
import com.ripple.cryptoconditions.PrefixSha256Condition;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.immutables.value.Value;

public interface PrefixSha256Fulfillment
extends Fulfillment<PrefixSha256Condition> {
    public static PrefixSha256Fulfillment from(byte[] prefix, long maxMessageLength, Fulfillment subfulfillment) {
        if (maxMessageLength < 0L) {
            throw new IllegalArgumentException("Maximum message length must not be negative!");
        }
        byte[] prefixInternal = Arrays.copyOf(prefix, prefix.length);
        String prefixBase64Url = Base64.getUrlEncoder().encodeToString(prefix);
        PrefixSha256Condition condition = PrefixSha256Condition.from(prefix, maxMessageLength, subfulfillment.getDerivedCondition());
        return ImmutablePrefixSha256Fulfillment.builder().type(CryptoConditionType.PREFIX_SHA256).prefix(prefixInternal).prefixBase64Url(prefixBase64Url).maxMessageLength(maxMessageLength).subfulfillment(subfulfillment).derivedCondition(condition).build();
    }

    @Deprecated
    public byte[] getPrefix();

    public String getPrefixBase64Url();

    public long getMaxMessageLength();

    public Fulfillment getSubfulfillment();

    @Value.Immutable
    public static abstract class AbstractPrefixSha256Fulfillment
    implements PrefixSha256Fulfillment {
        @Override
        public boolean verify(Condition condition, byte[] message) {
            Objects.requireNonNull(condition, "Can't verify a PrefixSha256Fulfillment against a null condition!");
            Objects.requireNonNull(message, "Message must not be null!");
            if ((long)message.length > this.getMaxMessageLength()) {
                throw new IllegalArgumentException(String.format("Message length (%s) exceeds maximum message length from (%s).", message.length, this.getMaxMessageLength()));
            }
            if (!((PrefixSha256Condition)this.getDerivedCondition()).equals(condition)) {
                return false;
            }
            byte[] decodedPrefix = Base64.getUrlDecoder().decode(this.getPrefixBase64Url());
            byte[] prefixedMessage = Arrays.copyOf(decodedPrefix, decodedPrefix.length + message.length);
            System.arraycopy(message, 0, prefixedMessage, decodedPrefix.length, message.length);
            Object subcondition = this.getSubfulfillment().getDerivedCondition();
            return this.getSubfulfillment().verify((Condition)subcondition, prefixedMessage);
        }

        public String toString() {
            return "PrefixSha256Fulfillment{prefix=" + this.getPrefixBase64Url() + ", maxMessageLength=" + this.getMaxMessageLength() + ", subfulfillment=" + this.getSubfulfillment() + ", type=" + (Object)((Object)this.getType()) + ", derivedCondition=" + this.getDerivedCondition() + "}";
        }
    }
}

