/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import com.ripple.cryptoconditions.ThresholdSha256Fulfillment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableThresholdSha256Fulfillment
extends ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment {
    private final List<Condition> subconditions;
    private final List<Fulfillment> subfulfillments;
    private final CryptoConditionType type;
    private final ThresholdSha256Condition derivedCondition;

    private ImmutableThresholdSha256Fulfillment(List<Condition> subconditions, List<Fulfillment> subfulfillments, CryptoConditionType type, ThresholdSha256Condition derivedCondition) {
        this.subconditions = subconditions;
        this.subfulfillments = subfulfillments;
        this.type = type;
        this.derivedCondition = derivedCondition;
    }

    @Override
    public List<Condition> getSubconditions() {
        return this.subconditions;
    }

    @Override
    public List<Fulfillment> getSubfulfillments() {
        return this.subfulfillments;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    public ThresholdSha256Condition getDerivedCondition() {
        return this.derivedCondition;
    }

    public final ImmutableThresholdSha256Fulfillment withSubconditions(Condition ... elements) {
        List<Condition> newValue = ImmutableThresholdSha256Fulfillment.createUnmodifiableList(false, ImmutableThresholdSha256Fulfillment.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableThresholdSha256Fulfillment(newValue, this.subfulfillments, this.type, this.derivedCondition);
    }

    public final ImmutableThresholdSha256Fulfillment withSubconditions(Iterable<? extends Condition> elements) {
        if (this.subconditions == elements) {
            return this;
        }
        List<Condition> newValue = ImmutableThresholdSha256Fulfillment.createUnmodifiableList(false, ImmutableThresholdSha256Fulfillment.createSafeList(elements, true, false));
        return new ImmutableThresholdSha256Fulfillment(newValue, this.subfulfillments, this.type, this.derivedCondition);
    }

    public final ImmutableThresholdSha256Fulfillment withSubfulfillments(Fulfillment ... elements) {
        List<Fulfillment> newValue = ImmutableThresholdSha256Fulfillment.createUnmodifiableList(false, ImmutableThresholdSha256Fulfillment.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableThresholdSha256Fulfillment(this.subconditions, newValue, this.type, this.derivedCondition);
    }

    public final ImmutableThresholdSha256Fulfillment withSubfulfillments(Iterable<? extends Fulfillment> elements) {
        if (this.subfulfillments == elements) {
            return this;
        }
        List<Fulfillment> newValue = ImmutableThresholdSha256Fulfillment.createUnmodifiableList(false, ImmutableThresholdSha256Fulfillment.createSafeList(elements, true, false));
        return new ImmutableThresholdSha256Fulfillment(this.subconditions, newValue, this.type, this.derivedCondition);
    }

    public final ImmutableThresholdSha256Fulfillment withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableThresholdSha256Fulfillment(this.subconditions, this.subfulfillments, newValue, this.derivedCondition);
    }

    public final ImmutableThresholdSha256Fulfillment withDerivedCondition(ThresholdSha256Condition value) {
        if (this.derivedCondition == value) {
            return this;
        }
        ThresholdSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
        return new ImmutableThresholdSha256Fulfillment(this.subconditions, this.subfulfillments, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThresholdSha256Fulfillment && this.equalTo((ImmutableThresholdSha256Fulfillment)another);
    }

    private boolean equalTo(ImmutableThresholdSha256Fulfillment another) {
        return this.subconditions.equals(another.subconditions) && this.subfulfillments.equals(another.subfulfillments) && this.type.equals((Object)another.type) && this.derivedCondition.equals(another.derivedCondition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.subconditions.hashCode();
        h += (h << 5) + this.subfulfillments.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.derivedCondition.hashCode();
        return h;
    }

    public String toString() {
        return "ThresholdSha256Fulfillment{subconditions=" + this.subconditions + ", subfulfillments=" + this.subfulfillments + ", type=" + (Object)((Object)this.type) + ", derivedCondition=" + this.derivedCondition + "}";
    }

    public static ImmutableThresholdSha256Fulfillment copyOf(ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment instance) {
        if (instance instanceof ImmutableThresholdSha256Fulfillment) {
            return (ImmutableThresholdSha256Fulfillment)instance;
        }
        return ImmutableThresholdSha256Fulfillment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_DERIVED_CONDITION = 2L;
        private long initBits = 3L;
        private List<Condition> subconditions = new ArrayList<Condition>();
        private List<Fulfillment> subfulfillments = new ArrayList<Fulfillment>();
        private CryptoConditionType type;
        private ThresholdSha256Condition derivedCondition;

        private Builder() {
        }

        public final Builder from(ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ThresholdSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ThresholdSha256Fulfillment instance;
            if (object instanceof ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment) {
                instance = (ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment)object;
                this.type(instance.getType());
                this.derivedCondition((ThresholdSha256Condition)instance.getDerivedCondition());
            }
            if (object instanceof ThresholdSha256Fulfillment) {
                instance = (ThresholdSha256Fulfillment)object;
                this.addAllSubconditions(instance.getSubconditions());
                this.addAllSubfulfillments(instance.getSubfulfillments());
            }
        }

        public final Builder addSubconditions(Condition element) {
            this.subconditions.add(Objects.requireNonNull(element, "subconditions element"));
            return this;
        }

        public final Builder addSubconditions(Condition ... elements) {
            for (Condition element : elements) {
                this.subconditions.add(Objects.requireNonNull(element, "subconditions element"));
            }
            return this;
        }

        public final Builder subconditions(Iterable<? extends Condition> elements) {
            this.subconditions.clear();
            return this.addAllSubconditions(elements);
        }

        public final Builder addAllSubconditions(Iterable<? extends Condition> elements) {
            for (Condition condition : elements) {
                this.subconditions.add(Objects.requireNonNull(condition, "subconditions element"));
            }
            return this;
        }

        public final Builder addSubfulfillments(Fulfillment element) {
            this.subfulfillments.add(Objects.requireNonNull(element, "subfulfillments element"));
            return this;
        }

        public final Builder addSubfulfillments(Fulfillment ... elements) {
            for (Fulfillment element : elements) {
                this.subfulfillments.add(Objects.requireNonNull(element, "subfulfillments element"));
            }
            return this;
        }

        public final Builder subfulfillments(Iterable<? extends Fulfillment> elements) {
            this.subfulfillments.clear();
            return this.addAllSubfulfillments(elements);
        }

        public final Builder addAllSubfulfillments(Iterable<? extends Fulfillment> elements) {
            for (Fulfillment fulfillment : elements) {
                this.subfulfillments.add(Objects.requireNonNull(fulfillment, "subfulfillments element"));
            }
            return this;
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder derivedCondition(ThresholdSha256Condition derivedCondition) {
            this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableThresholdSha256Fulfillment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThresholdSha256Fulfillment(ImmutableThresholdSha256Fulfillment.createUnmodifiableList(true, this.subconditions), ImmutableThresholdSha256Fulfillment.createUnmodifiableList(true, this.subfulfillments), this.type, this.derivedCondition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("derivedCondition");
            }
            return "Cannot build ThresholdSha256Fulfillment, some of required attributes are not set " + attributes;
        }
    }
}

