/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.RsaSha256Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ImmutableRsaSha256Condition
extends RsaSha256Condition.AbstractRsaSha256Condition {
    private final CryptoConditionType type;
    private final byte[] fingerprint;
    private final String fingerprintBase64Url;
    private final long cost;

    private ImmutableRsaSha256Condition(CryptoConditionType type, byte[] fingerprint, String fingerprintBase64Url, long cost) {
        this.type = type;
        this.fingerprint = fingerprint;
        this.fingerprintBase64Url = fingerprintBase64Url;
        this.cost = cost;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public byte[] getFingerprint() {
        return (byte[])this.fingerprint.clone();
    }

    @Override
    public String getFingerprintBase64Url() {
        return this.fingerprintBase64Url;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    public final ImmutableRsaSha256Condition withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableRsaSha256Condition(newValue, this.fingerprint, this.fingerprintBase64Url, this.cost);
    }

    @Deprecated
    public final ImmutableRsaSha256Condition withFingerprint(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableRsaSha256Condition(this.type, newValue, this.fingerprintBase64Url, this.cost);
    }

    public final ImmutableRsaSha256Condition withFingerprintBase64Url(String value) {
        if (this.fingerprintBase64Url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "fingerprintBase64Url");
        return new ImmutableRsaSha256Condition(this.type, this.fingerprint, newValue, this.cost);
    }

    public final ImmutableRsaSha256Condition withCost(long value) {
        if (this.cost == value) {
            return this;
        }
        return new ImmutableRsaSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRsaSha256Condition && this.equalTo((ImmutableRsaSha256Condition)another);
    }

    private boolean equalTo(ImmutableRsaSha256Condition another) {
        return this.type.equals((Object)another.type) && Arrays.equals(this.fingerprint, another.fingerprint) && this.fingerprintBase64Url.equals(another.fingerprintBase64Url) && this.cost == another.cost;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Arrays.hashCode(this.fingerprint);
        h += (h << 5) + this.fingerprintBase64Url.hashCode();
        h += (h << 5) + Long.hashCode(this.cost);
        return h;
    }

    public static ImmutableRsaSha256Condition copyOf(RsaSha256Condition.AbstractRsaSha256Condition instance) {
        if (instance instanceof ImmutableRsaSha256Condition) {
            return (ImmutableRsaSha256Condition)instance;
        }
        return ImmutableRsaSha256Condition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_FINGERPRINT = 2L;
        private static final long INIT_BIT_FINGERPRINT_BASE64_URL = 4L;
        private static final long INIT_BIT_COST = 8L;
        private long initBits = 15L;
        private CryptoConditionType type;
        private byte[] fingerprint;
        private String fingerprintBase64Url;
        private long cost;

        private Builder() {
        }

        public final Builder from(Condition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RsaSha256Condition.AbstractRsaSha256Condition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Condition) {
                Condition instance = (Condition)object;
                this.fingerprint(instance.getFingerprint());
                this.fingerprintBase64Url(instance.getFingerprintBase64Url());
                this.cost(instance.getCost());
                this.type(instance.getType());
            }
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder fingerprint(byte ... fingerprint) {
            this.fingerprint = (byte[])fingerprint.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fingerprintBase64Url(String fingerprintBase64Url) {
            this.fingerprintBase64Url = Objects.requireNonNull(fingerprintBase64Url, "fingerprintBase64Url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder cost(long cost) {
            this.cost = cost;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRsaSha256Condition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRsaSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, this.cost);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fingerprint");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fingerprintBase64Url");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("cost");
            }
            return "Cannot build RsaSha256Condition, some of required attributes are not set " + attributes;
        }
    }
}

