/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.PreimageSha256Condition;
import com.ripple.cryptoconditions.PreimageSha256Fulfillment;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutablePreimageSha256Fulfillment
extends PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment {
    private final String encodedPreimage;
    private final CryptoConditionType type;
    private final PreimageSha256Condition derivedCondition;

    private ImmutablePreimageSha256Fulfillment(String encodedPreimage, CryptoConditionType type, PreimageSha256Condition derivedCondition) {
        this.encodedPreimage = encodedPreimage;
        this.type = type;
        this.derivedCondition = derivedCondition;
    }

    @Override
    public String getEncodedPreimage() {
        return this.encodedPreimage;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    public PreimageSha256Condition getDerivedCondition() {
        return this.derivedCondition;
    }

    public final ImmutablePreimageSha256Fulfillment withEncodedPreimage(String value) {
        if (this.encodedPreimage.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "encodedPreimage");
        return new ImmutablePreimageSha256Fulfillment(newValue, this.type, this.derivedCondition);
    }

    public final ImmutablePreimageSha256Fulfillment withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutablePreimageSha256Fulfillment(this.encodedPreimage, newValue, this.derivedCondition);
    }

    public final ImmutablePreimageSha256Fulfillment withDerivedCondition(PreimageSha256Condition value) {
        if (this.derivedCondition == value) {
            return this;
        }
        PreimageSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
        return new ImmutablePreimageSha256Fulfillment(this.encodedPreimage, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreimageSha256Fulfillment && this.equalTo((ImmutablePreimageSha256Fulfillment)another);
    }

    private boolean equalTo(ImmutablePreimageSha256Fulfillment another) {
        return this.encodedPreimage.equals(another.encodedPreimage) && this.type.equals((Object)another.type) && this.derivedCondition.equals(another.derivedCondition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.encodedPreimage.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.derivedCondition.hashCode();
        return h;
    }

    public String toString() {
        return "PreimageSha256Fulfillment{encodedPreimage=" + this.encodedPreimage + ", type=" + (Object)((Object)this.type) + ", derivedCondition=" + this.derivedCondition + "}";
    }

    public static ImmutablePreimageSha256Fulfillment copyOf(PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment instance) {
        if (instance instanceof ImmutablePreimageSha256Fulfillment) {
            return (ImmutablePreimageSha256Fulfillment)instance;
        }
        return ImmutablePreimageSha256Fulfillment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ENCODED_PREIMAGE = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_DERIVED_CONDITION = 4L;
        private long initBits = 7L;
        private String encodedPreimage;
        private CryptoConditionType type;
        private PreimageSha256Condition derivedCondition;

        private Builder() {
        }

        public final Builder from(PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PreimageSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PreimageSha256Fulfillment instance;
            if (object instanceof PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment) {
                instance = (PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment)object;
                this.type(instance.getType());
                this.derivedCondition((PreimageSha256Condition)instance.getDerivedCondition());
            }
            if (object instanceof PreimageSha256Fulfillment) {
                instance = (PreimageSha256Fulfillment)object;
                this.encodedPreimage(instance.getEncodedPreimage());
            }
        }

        public final Builder encodedPreimage(String encodedPreimage) {
            this.encodedPreimage = Objects.requireNonNull(encodedPreimage, "encodedPreimage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder derivedCondition(PreimageSha256Condition derivedCondition) {
            this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePreimageSha256Fulfillment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreimageSha256Fulfillment(this.encodedPreimage, this.type, this.derivedCondition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("encodedPreimage");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("derivedCondition");
            }
            return "Cannot build PreimageSha256Fulfillment, some of required attributes are not set " + attributes;
        }
    }
}

