/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Ed25519Sha256Condition;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.ImmutableEd25519Sha256Fulfillment;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.immutables.value.Value;

public interface Ed25519Sha256Fulfillment
extends Fulfillment<Ed25519Sha256Condition> {
    public static Ed25519Sha256Fulfillment from(EdDSAPublicKey publicKey, byte[] signature) {
        Objects.requireNonNull(publicKey, "EdDSAPublicKey must not be null!");
        Objects.requireNonNull(signature, "Signature must not be null!");
        if (signature.length != 64) {
            throw new IllegalArgumentException("Signature length must be 64 bytes for Ed25519Sha256Fulfillments!");
        }
        byte[] immutableSignature = Arrays.copyOf(signature, signature.length);
        String signatureBase64Url = Base64.getUrlEncoder().encodeToString(signature);
        Ed25519Sha256Condition condition = Ed25519Sha256Condition.from(publicKey);
        return ImmutableEd25519Sha256Fulfillment.builder().type(CryptoConditionType.ED25519_SHA256).publicKey(publicKey).signature(immutableSignature).signatureBase64Url(signatureBase64Url).derivedCondition(condition).build();
    }

    public EdDSAPublicKey getPublicKey();

    @Deprecated
    public byte[] getSignature();

    public String getSignatureBase64Url();

    @Value.Immutable
    public static abstract class AbstractEd25519Sha256Fulfillment
    implements Ed25519Sha256Fulfillment {
        @Override
        public boolean verify(Condition condition, byte[] message) {
            Objects.requireNonNull(condition, "Can't verify a Ed25519Sha256Fulfillment against an null condition.");
            Objects.requireNonNull(message, "Message must not be null!");
            if (!((Ed25519Sha256Condition)this.getDerivedCondition()).equals(condition)) {
                return false;
            }
            try {
                byte[] signatureBytes = Base64.getUrlDecoder().decode(this.getSignatureBase64Url());
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                EdDSAEngine edDsaSigner = new EdDSAEngine(messageDigest);
                edDsaSigner.initVerify((PublicKey)this.getPublicKey());
                edDsaSigner.update(message);
                return edDsaSigner.verify(signatureBytes);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "Ed25519Sha256Fulfillment{publicKey=" + this.getPublicKey() + ", signature=" + this.getSignatureBase64Url() + ", type=" + (Object)((Object)this.getType()) + ", condition=" + this.getDerivedCondition() + "}";
        }
    }
}

