/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.ConditionBase;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.ImmutableEd25519Sha256Condition;
import com.ripple.cryptoconditions.Sha256Condition;
import com.ripple.cryptoconditions.der.DerOutputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.HashUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.immutables.value.Value;

public interface Ed25519Sha256Condition
extends Sha256Condition {
    public static Ed25519Sha256Condition from(EdDSAPublicKey edDsaPublicKey) {
        Objects.requireNonNull(edDsaPublicKey);
        byte[] fingerprint = HashUtils.hashFingerprintContents(AbstractEd25519Sha256Condition.constructFingerprintContents(edDsaPublicKey));
        return ImmutableEd25519Sha256Condition.builder().type(CryptoConditionType.ED25519_SHA256).cost(131072L).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    public static Ed25519Sha256Condition fromCostAndFingerprint(byte[] fingerprint) {
        Objects.requireNonNull(fingerprint);
        return ImmutableEd25519Sha256Condition.builder().type(CryptoConditionType.ED25519_SHA256).cost(131072L).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    @Value.Immutable
    public static abstract class AbstractEd25519Sha256Condition
    extends ConditionBase<Ed25519Sha256Condition>
    implements Ed25519Sha256Condition {
        static final long COST = 131072L;

        static final byte[] constructFingerprintContents(EdDSAPublicKey publicKey) {
            Objects.requireNonNull(publicKey);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DerOutputStream out = new DerOutputStream(baos);
                out.writeTaggedObject(0, publicKey.getA().toByteArray());
                out.close();
                byte[] buffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DerOutputStream(baos);
                out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.SEQUENCE.getTag(), buffer);
                out.close();
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("DER Encoding Error", ioe);
            }
        }

        public String toString() {
            return "Ed25519Sha256Condition{type=" + (Object)((Object)this.getType()) + ", fingerprint=" + this.getFingerprintBase64Url() + ", cost=" + this.getCost() + "}";
        }
    }
}

