/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CompoundCondition;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Ed25519Sha256Condition;
import com.ripple.cryptoconditions.Ed25519Sha256Fulfillment;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.PrefixSha256Condition;
import com.ripple.cryptoconditions.PrefixSha256Fulfillment;
import com.ripple.cryptoconditions.PreimageSha256Condition;
import com.ripple.cryptoconditions.PreimageSha256Fulfillment;
import com.ripple.cryptoconditions.RsaSha256Condition;
import com.ripple.cryptoconditions.RsaSha256Fulfillment;
import com.ripple.cryptoconditions.SimpleCondition;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import com.ripple.cryptoconditions.ThresholdSha256Fulfillment;
import com.ripple.cryptoconditions.der.DerEncodingException;
import com.ripple.cryptoconditions.der.DerOutputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.UnsignedBigInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Objects;

public class CryptoConditionWriter {
    public static byte[] writeCondition(Condition condition) throws DerEncodingException {
        Objects.requireNonNull(condition);
        if (condition instanceof PreimageSha256Condition) {
            return CryptoConditionWriter.writeSingleCondition((PreimageSha256Condition)condition);
        }
        if (condition instanceof PrefixSha256Condition) {
            return CryptoConditionWriter.writeCompoundCondition((PrefixSha256Condition)condition);
        }
        if (condition instanceof Ed25519Sha256Condition) {
            return CryptoConditionWriter.writeSingleCondition((Ed25519Sha256Condition)condition);
        }
        if (condition instanceof RsaSha256Condition) {
            return CryptoConditionWriter.writeSingleCondition((RsaSha256Condition)condition);
        }
        if (condition instanceof ThresholdSha256Condition) {
            return CryptoConditionWriter.writeCompoundCondition((ThresholdSha256Condition)condition);
        }
        throw new IllegalArgumentException(String.format("Unhandled Condition type: %s", condition.getClass().getName()));
    }

    public static byte[] writeFulfillment(Fulfillment fulfillment) throws DerEncodingException {
        Objects.requireNonNull(fulfillment);
        if (fulfillment instanceof PreimageSha256Fulfillment) {
            return CryptoConditionWriter.writeTypedFulfillment((PreimageSha256Fulfillment)fulfillment);
        }
        if (fulfillment instanceof PrefixSha256Fulfillment) {
            return CryptoConditionWriter.writeTypedFulfillment((PrefixSha256Fulfillment)fulfillment);
        }
        if (fulfillment instanceof Ed25519Sha256Fulfillment) {
            return CryptoConditionWriter.writeTypedFulfillment((Ed25519Sha256Fulfillment)fulfillment);
        }
        if (fulfillment instanceof RsaSha256Fulfillment) {
            return CryptoConditionWriter.writeTypedFulfillment((RsaSha256Fulfillment)fulfillment);
        }
        if (fulfillment instanceof ThresholdSha256Fulfillment) {
            return CryptoConditionWriter.writeTypedFulfillment((ThresholdSha256Fulfillment)fulfillment);
        }
        throw new IllegalArgumentException(String.format("Unhandled Fulfillment type: %s", fulfillment.getClass().getName()));
    }

    private static byte[] writeSingleCondition(SimpleCondition condition) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, condition.getFingerprint());
            out.writeTaggedObject(1, BigInteger.valueOf(condition.getCost()).toByteArray());
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.TAGGED.getTag() + condition.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("DER Encoding Error.", ioe);
        }
    }

    private static byte[] writeCompoundCondition(CompoundCondition condition) throws DerEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, condition.getFingerprint());
            out.writeTaggedObject(1, BigInteger.valueOf(condition.getCost()).toByteArray());
            byte[] bitStringData = CryptoConditionType.getEnumOfTypesAsBitString(condition.getSubtypes());
            out.writeTaggedObject(2, bitStringData);
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.TAGGED.getTag() + condition.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("DER Encoding Error.", ioe);
        }
    }

    private static byte[] writeTypedFulfillment(PreimageSha256Fulfillment fulfillment) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, Base64.getUrlDecoder().decode(fulfillment.getEncodedPreimage()));
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(fulfillment.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("DER Encoding Error", e);
        }
    }

    private static byte[] writeTypedFulfillment(PrefixSha256Fulfillment fulfillment) throws DerEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, fulfillment.getPrefix());
            out.writeTaggedObject(1, BigInteger.valueOf(fulfillment.getMaxMessageLength()).toByteArray());
            out.writeTaggedConstructedObject(2, CryptoConditionWriter.writeFulfillment(fulfillment.getSubfulfillment()));
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(fulfillment.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("DER Encoding Error", ioe);
        }
    }

    private static byte[] writeTypedFulfillment(RsaSha256Fulfillment fulfillment) throws DerEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, UnsignedBigInteger.toUnsignedByteArray(fulfillment.getPublicKey().getModulus()));
            out.writeTaggedObject(1, fulfillment.getSignature());
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(fulfillment.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("DER Encoding Error", e);
        }
    }

    private static byte[] writeTypedFulfillment(Ed25519Sha256Fulfillment fulfillment) throws DerEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedObject(0, fulfillment.getPublicKey().getA().toByteArray());
            out.writeTaggedObject(1, fulfillment.getSignature());
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(fulfillment.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("DER Encoding Error", e);
        }
    }

    private static byte[] writeTypedFulfillment(ThresholdSha256Fulfillment fulfillment) throws DerEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < fulfillment.getSubfulfillments().size(); ++i) {
                baos.write(CryptoConditionWriter.writeFulfillment(fulfillment.getSubfulfillments().get(i)));
            }
            baos.close();
            byte[] fulfillmentsBuffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            DerOutputStream out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(0, fulfillmentsBuffer);
            out.close();
            fulfillmentsBuffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            for (int i = 0; i < fulfillment.getSubconditions().size(); ++i) {
                baos.write(CryptoConditionWriter.writeCondition(fulfillment.getSubconditions().get(i)));
            }
            out.close();
            byte[] conditionsBuffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(1, conditionsBuffer);
            out.close();
            conditionsBuffer = baos.toByteArray();
            byte[] buffer = new byte[fulfillmentsBuffer.length + conditionsBuffer.length];
            System.arraycopy(fulfillmentsBuffer, 0, buffer, 0, fulfillmentsBuffer.length);
            System.arraycopy(conditionsBuffer, 0, buffer, fulfillmentsBuffer.length, conditionsBuffer.length);
            baos = new ByteArrayOutputStream();
            out = new DerOutputStream(baos);
            out.writeTaggedConstructedObject(fulfillment.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("DER Encoding Error", ioe);
        }
    }
}

