/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public enum CryptoConditionType {
    PREIMAGE_SHA256(0, "PREIMAGE-SHA-256", 128, 0),
    PREFIX_SHA256(1, "PREFIX-SHA-256", 64, 0),
    THRESHOLD_SHA256(2, "THRESHOLD-SHA-256", 32, 0),
    RSA_SHA256(3, "RSA-SHA-256", 16, 0),
    ED25519_SHA256(4, "ED25519-SHA-256", 8, 0);

    private final int typeCode;
    private final String name;
    private final int bitMask;
    private final int byteIndex;

    private CryptoConditionType(int typeCode, String algorithmName, int bitMask, int byteIndex) {
        this.typeCode = typeCode;
        this.name = Objects.requireNonNull(algorithmName);
        this.bitMask = bitMask;
        this.byteIndex = byteIndex;
    }

    public static CryptoConditionType valueOf(int typeCode) {
        for (CryptoConditionType conditionType : EnumSet.allOf(CryptoConditionType.class)) {
            if (typeCode != conditionType.typeCode) continue;
            return conditionType;
        }
        throw new IllegalArgumentException("Invalid Condition Type code.");
    }

    public static byte[] getEnumOfTypesAsBitString(EnumSet<CryptoConditionType> types) {
        byte[] data = new byte[2];
        int lastUsedBit = -1;
        if (types.contains((Object)PREIMAGE_SHA256)) {
            data[1] = (byte)(data[1] + PREIMAGE_SHA256.getMask());
            lastUsedBit = PREIMAGE_SHA256.getTypeCode();
        }
        if (types.contains((Object)PREFIX_SHA256)) {
            data[1] = (byte)(data[1] + PREFIX_SHA256.getMask());
            lastUsedBit = PREFIX_SHA256.getTypeCode();
        }
        if (types.contains((Object)THRESHOLD_SHA256)) {
            data[1] = (byte)(data[1] + THRESHOLD_SHA256.getMask());
            lastUsedBit = THRESHOLD_SHA256.getTypeCode();
        }
        if (types.contains((Object)RSA_SHA256)) {
            data[1] = (byte)(data[1] + RSA_SHA256.getMask());
            lastUsedBit = RSA_SHA256.getTypeCode();
        }
        if (types.contains((Object)ED25519_SHA256)) {
            data[1] = (byte)(data[1] + ED25519_SHA256.getMask());
            lastUsedBit = ED25519_SHA256.getTypeCode();
        }
        if (lastUsedBit > -1) {
            data[0] = (byte)(7 - lastUsedBit);
            return data;
        }
        return new byte[]{0};
    }

    public static String getEnumOfTypesAsString(EnumSet<CryptoConditionType> types) {
        Object[] names = new String[types.size()];
        int idx = 0;
        for (CryptoConditionType conditionType : types) {
            names[idx++] = conditionType.toString().toLowerCase();
        }
        Arrays.sort(names);
        return String.join((CharSequence)",", (CharSequence[])names);
    }

    public static CryptoConditionType fromString(String typeName) {
        for (CryptoConditionType conditionType : EnumSet.allOf(CryptoConditionType.class)) {
            if (!conditionType.name.equalsIgnoreCase(typeName)) continue;
            return conditionType;
        }
        throw new IllegalArgumentException("Invalid Condition Type name.");
    }

    public static EnumSet<CryptoConditionType> getEnumOfTypesFromString(String subtypes) {
        String[] names;
        EnumSet<CryptoConditionType> types = EnumSet.noneOf(CryptoConditionType.class);
        if (subtypes == null || subtypes.trim().isEmpty()) {
            return types;
        }
        for (String typeName : names = subtypes.split(",")) {
            types.add(CryptoConditionType.fromString(typeName));
        }
        return types;
    }

    public static EnumSet<CryptoConditionType> getEnumOfTypesFromBitString(byte[] bitStringData) {
        if (bitStringData.length > 2) {
            throw new IllegalArgumentException("Unknown rsa in bit string.");
        }
        if (bitStringData.length == 1) {
            throw new IllegalArgumentException("Corrupt bit string.");
        }
        EnumSet<CryptoConditionType> subtypes = EnumSet.noneOf(CryptoConditionType.class);
        if (bitStringData.length == 0) {
            return subtypes;
        }
        byte padBits = bitStringData[0];
        if (padBits < 3) {
            throw new IllegalArgumentException("Unknown rsa in bit string.");
        }
        for (CryptoConditionType type : CryptoConditionType.values()) {
            if (!type.isBitSet(bitStringData)) continue;
            subtypes.add(type);
        }
        return subtypes;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String toString() {
        return this.name;
    }

    public int getMask() {
        return this.bitMask;
    }

    public int getByteIndex() {
        return this.byteIndex;
    }

    private boolean isBitSet(byte[] bitString) {
        return bitString.length - 2 >= this.byteIndex && (bitString[this.byteIndex + 1] & this.bitMask) == this.bitMask;
    }
}

