/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionWriter;
import com.ripple.cryptoconditions.der.DerEncodingException;

public abstract class ConditionBase<C extends Condition>
implements Condition {
    @Override
    public final int compareTo(Condition that) {
        try {
            byte[] c1encoded = CryptoConditionWriter.writeCondition(this);
            byte[] c2encoded = CryptoConditionWriter.writeCondition(that);
            int minLength = Math.min(c1encoded.length, c2encoded.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Integer.compareUnsigned(c1encoded[i], c2encoded[i]);
                if (result == 0) continue;
                return result;
            }
            return c1encoded.length - c2encoded.length;
        }
        catch (DerEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

