/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CryptoConditionType;
import org.immutables.value.Value;

public interface Condition
extends Comparable<Condition> {
    public CryptoConditionType getType();

    @Deprecated
    public byte[] getFingerprint();

    public String getFingerprintBase64Url();

    public long getCost();

    public static abstract class AbstractCondition
    implements Condition {
        @Value.Check
        protected void check() {
            if (this.getFingerprint().length != 32) {
                throw new IllegalArgumentException("Fingerprint must be 32 bytes.");
            }
            if (this.getCost() < 0L) {
                throw new IllegalArgumentException("Cost must be positive!");
            }
        }
    }
}

