package com.ripple.cryptoconditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableThresholdSha256Fulfillment.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment"})
public final class ImmutableThresholdSha256Fulfillment
    extends ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment {
  private final List<Condition> subconditions;
  private final List<Fulfillment> subfulfillments;
  private final CryptoConditionType type;
  private final ThresholdSha256Condition derivedCondition;

  private ImmutableThresholdSha256Fulfillment(
      List<Condition> subconditions,
      List<Fulfillment> subfulfillments,
      CryptoConditionType type,
      ThresholdSha256Condition derivedCondition) {
    this.subconditions = subconditions;
    this.subfulfillments = subfulfillments;
    this.type = type;
    this.derivedCondition = derivedCondition;
  }

  /**
   * Accessor for the subconditions of this fulfillment.
   * @return An unordered {@link List} of zero or more sub-conditions.
   */
  @Override
  public List<Condition> getSubconditions() {
    return subconditions;
  }

  /**
   * Accessor for the subfulfillments of this fulfillment.
   * @return An unordered {@link List} of zero or more sub-fulfillments.
   */
  @Override
  public List<Fulfillment> getSubfulfillments() {
    return subfulfillments;
  }

  /**
   * Accessor for the type of this fulfillment.
   * @return A {@link CryptoConditionType} for this fulfillment.
   */
  @Override
  public CryptoConditionType getType() {
    return type;
  }

  /**
   * Accessor for the condition that corresponds to this fulfillment.
   * @return A {@link Condition} that can be fulfilled by this fulfillment.
   */
  @Override
  public ThresholdSha256Condition getDerivedCondition() {
    return derivedCondition;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withSubconditions(Condition... elements) {
    List<Condition> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableThresholdSha256Fulfillment(newValue, this.subfulfillments, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subconditions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withSubconditions(Iterable<? extends Condition> elements) {
    if (this.subconditions == elements) return this;
    List<Condition> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableThresholdSha256Fulfillment(newValue, this.subfulfillments, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withSubfulfillments(Fulfillment... elements) {
    List<Fulfillment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableThresholdSha256Fulfillment(this.subconditions, newValue, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subfulfillments elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withSubfulfillments(Iterable<? extends Fulfillment> elements) {
    if (this.subfulfillments == elements) return this;
    List<Fulfillment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableThresholdSha256Fulfillment(this.subconditions, newValue, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withType(CryptoConditionType value) {
    if (this.type == value) return this;
    CryptoConditionType newValue = Objects.requireNonNull(value, "type");
    return new ImmutableThresholdSha256Fulfillment(this.subconditions, this.subfulfillments, newValue, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for derivedCondition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThresholdSha256Fulfillment withDerivedCondition(ThresholdSha256Condition value) {
    if (this.derivedCondition == value) return this;
    ThresholdSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
    return new ImmutableThresholdSha256Fulfillment(this.subconditions, this.subfulfillments, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableThresholdSha256Fulfillment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableThresholdSha256Fulfillment
        && equalTo((ImmutableThresholdSha256Fulfillment) another);
  }

  private boolean equalTo(ImmutableThresholdSha256Fulfillment another) {
    return subconditions.equals(another.subconditions)
        && subfulfillments.equals(another.subfulfillments)
        && type.equals(another.type)
        && derivedCondition.equals(another.derivedCondition);
  }

  /**
   * Computes a hash code from attributes: {@code subconditions}, {@code subfulfillments}, {@code type}, {@code derivedCondition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + subconditions.hashCode();
    h += (h << 5) + subfulfillments.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + derivedCondition.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ThresholdSha256Fulfillment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ThresholdSha256Fulfillment{"
        + "subconditions=" + subconditions
        + ", subfulfillments=" + subfulfillments
        + ", type=" + type
        + ", derivedCondition=" + derivedCondition
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ThresholdSha256Fulfillment instance
   */
  public static ImmutableThresholdSha256Fulfillment copyOf(ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment instance) {
    if (instance instanceof ImmutableThresholdSha256Fulfillment) {
      return (ImmutableThresholdSha256Fulfillment) instance;
    }
    return ImmutableThresholdSha256Fulfillment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableThresholdSha256Fulfillment ImmutableThresholdSha256Fulfillment}.
   * @return A new ImmutableThresholdSha256Fulfillment builder
   */
  public static ImmutableThresholdSha256Fulfillment.Builder builder() {
    return new ImmutableThresholdSha256Fulfillment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableThresholdSha256Fulfillment ImmutableThresholdSha256Fulfillment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_DERIVED_CONDITION = 0x2L;
    private long initBits = 0x3L;

    private List<Condition> subconditions = new ArrayList<Condition>();
    private List<Fulfillment> subfulfillments = new ArrayList<Fulfillment>();
    private CryptoConditionType type;
    private ThresholdSha256Condition derivedCondition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.ThresholdSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ThresholdSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment) {
        ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment instance = (ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment) object;
        type(instance.getType());
        derivedCondition(instance.getDerivedCondition());
      }
      if (object instanceof ThresholdSha256Fulfillment) {
        ThresholdSha256Fulfillment instance = (ThresholdSha256Fulfillment) object;
        addAllSubconditions(instance.getSubconditions());
        addAllSubfulfillments(instance.getSubfulfillments());
      }
    }

    /**
     * Adds one element to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions} list.
     * @param element A subconditions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubconditions(Condition element) {
      this.subconditions.add(Objects.requireNonNull(element, "subconditions element"));
      return this;
    }

    /**
     * Adds elements to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions} list.
     * @param elements An array of subconditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubconditions(Condition... elements) {
      for (Condition element : elements) {
        this.subconditions.add(Objects.requireNonNull(element, "subconditions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions} list.
     * @param elements An iterable of subconditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subconditions(Iterable<? extends Condition> elements) {
      this.subconditions.clear();
      return addAllSubconditions(elements);
    }

    /**
     * Adds elements to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubconditions() subconditions} list.
     * @param elements An iterable of subconditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSubconditions(Iterable<? extends Condition> elements) {
      for (Condition element : elements) {
        this.subconditions.add(Objects.requireNonNull(element, "subconditions element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments} list.
     * @param element A subfulfillments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubfulfillments(Fulfillment element) {
      this.subfulfillments.add(Objects.requireNonNull(element, "subfulfillments element"));
      return this;
    }

    /**
     * Adds elements to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments} list.
     * @param elements An array of subfulfillments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSubfulfillments(Fulfillment... elements) {
      for (Fulfillment element : elements) {
        this.subfulfillments.add(Objects.requireNonNull(element, "subfulfillments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments} list.
     * @param elements An iterable of subfulfillments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subfulfillments(Iterable<? extends Fulfillment> elements) {
      this.subfulfillments.clear();
      return addAllSubfulfillments(elements);
    }

    /**
     * Adds elements to {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getSubfulfillments() subfulfillments} list.
     * @param elements An iterable of subfulfillments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSubfulfillments(Iterable<? extends Fulfillment> elements) {
      for (Fulfillment element : elements) {
        this.subfulfillments.add(Objects.requireNonNull(element, "subfulfillments element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(CryptoConditionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ThresholdSha256Fulfillment.AbstractThresholdSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
     * @param derivedCondition The value for derivedCondition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder derivedCondition(ThresholdSha256Condition derivedCondition) {
      this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
      initBits &= ~INIT_BIT_DERIVED_CONDITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableThresholdSha256Fulfillment ImmutableThresholdSha256Fulfillment}.
     * @return An immutable instance of ThresholdSha256Fulfillment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableThresholdSha256Fulfillment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableThresholdSha256Fulfillment(
          createUnmodifiableList(true, subconditions),
          createUnmodifiableList(true, subfulfillments),
          type,
          derivedCondition);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_DERIVED_CONDITION) != 0) attributes.add("derivedCondition");
      return "Cannot build ThresholdSha256Fulfillment, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
