package com.ripple.cryptoconditions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePreimageSha256Fulfillment.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment"})
public final class ImmutablePreimageSha256Fulfillment
    extends PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment {
  private final String encodedPreimage;
  private final CryptoConditionType type;
  private final PreimageSha256Condition derivedCondition;

  private ImmutablePreimageSha256Fulfillment(
      String encodedPreimage,
      CryptoConditionType type,
      PreimageSha256Condition derivedCondition) {
    this.encodedPreimage = encodedPreimage;
    this.type = type;
    this.derivedCondition = derivedCondition;
  }

  /**
   * Accessor for this fulfillment's preimage, using Base64URL encoding.
   * @return A {@link String} containing the base64Url-encoded preimage.
   */
  @Override
  public String getEncodedPreimage() {
    return encodedPreimage;
  }

  /**
   * Accessor for the type of this fulfillment.
   * @return A {@link CryptoConditionType} for this fulfillment.
   */
  @Override
  public CryptoConditionType getType() {
    return type;
  }

  /**
   * Accessor for the condition that corresponds to this fulfillment.
   * @return A {@link Condition} that can be fulfilled by this fulfillment.
   */
  @Override
  public PreimageSha256Condition getDerivedCondition() {
    return derivedCondition;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getEncodedPreimage() encodedPreimage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for encodedPreimage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Fulfillment withEncodedPreimage(String value) {
    if (this.encodedPreimage.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "encodedPreimage");
    return new ImmutablePreimageSha256Fulfillment(newValue, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Fulfillment withType(CryptoConditionType value) {
    if (this.type == value) return this;
    CryptoConditionType newValue = Objects.requireNonNull(value, "type");
    return new ImmutablePreimageSha256Fulfillment(this.encodedPreimage, newValue, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for derivedCondition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Fulfillment withDerivedCondition(PreimageSha256Condition value) {
    if (this.derivedCondition == value) return this;
    PreimageSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
    return new ImmutablePreimageSha256Fulfillment(this.encodedPreimage, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePreimageSha256Fulfillment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePreimageSha256Fulfillment
        && equalTo((ImmutablePreimageSha256Fulfillment) another);
  }

  private boolean equalTo(ImmutablePreimageSha256Fulfillment another) {
    return encodedPreimage.equals(another.encodedPreimage)
        && type.equals(another.type)
        && derivedCondition.equals(another.derivedCondition);
  }

  /**
   * Computes a hash code from attributes: {@code encodedPreimage}, {@code type}, {@code derivedCondition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + encodedPreimage.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + derivedCondition.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PreimageSha256Fulfillment} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PreimageSha256Fulfillment{"
        + "encodedPreimage=" + encodedPreimage
        + ", type=" + type
        + ", derivedCondition=" + derivedCondition
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PreimageSha256Fulfillment instance
   */
  public static ImmutablePreimageSha256Fulfillment copyOf(PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment instance) {
    if (instance instanceof ImmutablePreimageSha256Fulfillment) {
      return (ImmutablePreimageSha256Fulfillment) instance;
    }
    return ImmutablePreimageSha256Fulfillment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePreimageSha256Fulfillment ImmutablePreimageSha256Fulfillment}.
   * @return A new ImmutablePreimageSha256Fulfillment builder
   */
  public static ImmutablePreimageSha256Fulfillment.Builder builder() {
    return new ImmutablePreimageSha256Fulfillment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePreimageSha256Fulfillment ImmutablePreimageSha256Fulfillment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ENCODED_PREIMAGE = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_DERIVED_CONDITION = 0x4L;
    private long initBits = 0x7L;

    private String encodedPreimage;
    private CryptoConditionType type;
    private PreimageSha256Condition derivedCondition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.PreimageSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PreimageSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment) {
        PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment instance = (PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment) object;
        type(instance.getType());
        derivedCondition(instance.getDerivedCondition());
      }
      if (object instanceof PreimageSha256Fulfillment) {
        PreimageSha256Fulfillment instance = (PreimageSha256Fulfillment) object;
        encodedPreimage(instance.getEncodedPreimage());
      }
    }

    /**
     * Initializes the value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getEncodedPreimage() encodedPreimage} attribute.
     * @param encodedPreimage The value for encodedPreimage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder encodedPreimage(String encodedPreimage) {
      this.encodedPreimage = Objects.requireNonNull(encodedPreimage, "encodedPreimage");
      initBits &= ~INIT_BIT_ENCODED_PREIMAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(CryptoConditionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link PreimageSha256Fulfillment.AbstractPreimageSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
     * @param derivedCondition The value for derivedCondition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder derivedCondition(PreimageSha256Condition derivedCondition) {
      this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
      initBits &= ~INIT_BIT_DERIVED_CONDITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePreimageSha256Fulfillment ImmutablePreimageSha256Fulfillment}.
     * @return An immutable instance of PreimageSha256Fulfillment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePreimageSha256Fulfillment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePreimageSha256Fulfillment(encodedPreimage, type, derivedCondition);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ENCODED_PREIMAGE) != 0) attributes.add("encodedPreimage");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_DERIVED_CONDITION) != 0) attributes.add("derivedCondition");
      return "Cannot build PreimageSha256Fulfillment, some of required attributes are not set " + attributes;
    }
  }
}
