package com.ripple.cryptoconditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PreimageSha256Condition.AbstractPreimageSha256Condition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePreimageSha256Condition.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "PreimageSha256Condition.AbstractPreimageSha256Condition"})
public final class ImmutablePreimageSha256Condition
    extends PreimageSha256Condition.AbstractPreimageSha256Condition {
  private final CryptoConditionType type;
  private final byte[] fingerprint;
  private final String fingerprintBase64Url;
  private final long cost;

  private ImmutablePreimageSha256Condition(
      CryptoConditionType type,
      byte[] fingerprint,
      String fingerprintBase64Url,
      long cost) {
    this.type = type;
    this.fingerprint = fingerprint;
    this.fingerprintBase64Url = fingerprintBase64Url;
    this.cost = cost;
  }

  /**
   * The type identifier representing the condition type.
   * @return the type of this condition
   */
  @Override
  public CryptoConditionType getType() {
    return type;
  }

  /**
   * <p>A fingerprint is a binary (aka "octet") string uniquely representing the condition with
   * respect to other conditions of the same type. Implementations which index conditions MUST use
   * the  entire string or binary encoded condition as the key - not just the fingerprint - as
   * different conditions of different rsa may have the same fingerprint. The length and contents of
   * the fingerprint are defined by the condition type. The fingerprint is a cryptographically
   * secure hash of the data which defines the condition, such as a public key.</p>
   * <p>WARNING: This method MUST perform a safe copy of the internal data to protect immutability.
   * Callers should use {@link #getFingerprintBase64Url()} instead if possible.</p>
   * @return A read-only byte array that contains the unique fingerprint of this condition.
   */
  @Deprecated
  @Override
  public byte[] getFingerprint() {
    return fingerprint.clone();
  }

  /**
   * <p>A fingerprint is a binary (aka "octet") string uniquely representing the condition with
   * respect to other conditions of the same type. Implementations which index conditions MUST use
   * the entire string or binary encoded condition as the key - not just the fingerprint - as
   * different conditions of different rsa may have the same fingerprint. The length and contents of
   * the fingerprint are defined by the condition type. The fingerprint is a cryptographically
   * secure hash of the data which defines the condition, such as a public key.</p>
   * @return A Base64Url-encoded {@link String} that contains the unique fingerprint of this
   *     condition.
   */
  @Override
  public String getFingerprintBase64Url() {
    return fingerprintBase64Url;
  }

  /**
   * The estimated "cost" of processing a fulfillment of this condition. For details of how to
   * calculate this number see the Crypto-conditions specification.
   * @return the cost of validating the fulfillment of this condition
   */
  @Override
  public long getCost() {
    return cost;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Condition withType(CryptoConditionType value) {
    if (this.type == value) return this;
    CryptoConditionType newValue = Objects.requireNonNull(value, "type");
    return new ImmutablePreimageSha256Condition(newValue, this.fingerprint, this.fingerprintBase64Url, this.cost);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getFingerprint() fingerprint}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for fingerprint
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutablePreimageSha256Condition withFingerprint(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutablePreimageSha256Condition(this.type, newValue, this.fingerprintBase64Url, this.cost);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getFingerprintBase64Url() fingerprintBase64Url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fingerprintBase64Url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Condition withFingerprintBase64Url(String value) {
    if (this.fingerprintBase64Url.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "fingerprintBase64Url");
    return new ImmutablePreimageSha256Condition(this.type, this.fingerprint, newValue, this.cost);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getCost() cost} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cost
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePreimageSha256Condition withCost(long value) {
    if (this.cost == value) return this;
    return new ImmutablePreimageSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePreimageSha256Condition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePreimageSha256Condition
        && equalTo((ImmutablePreimageSha256Condition) another);
  }

  private boolean equalTo(ImmutablePreimageSha256Condition another) {
    return type.equals(another.type)
        && Arrays.equals(fingerprint, another.fingerprint)
        && fingerprintBase64Url.equals(another.fingerprintBase64Url)
        && cost == another.cost;
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code fingerprint}, {@code fingerprintBase64Url}, {@code cost}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Arrays.hashCode(fingerprint);
    h += (h << 5) + fingerprintBase64Url.hashCode();
    h += (h << 5) + Long.hashCode(cost);
    return h;
  }

  /**
   * Creates an immutable copy of a {@link PreimageSha256Condition.AbstractPreimageSha256Condition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PreimageSha256Condition instance
   */
  public static ImmutablePreimageSha256Condition copyOf(PreimageSha256Condition.AbstractPreimageSha256Condition instance) {
    if (instance instanceof ImmutablePreimageSha256Condition) {
      return (ImmutablePreimageSha256Condition) instance;
    }
    return ImmutablePreimageSha256Condition.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePreimageSha256Condition ImmutablePreimageSha256Condition}.
   * @return A new ImmutablePreimageSha256Condition builder
   */
  public static ImmutablePreimageSha256Condition.Builder builder() {
    return new ImmutablePreimageSha256Condition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePreimageSha256Condition ImmutablePreimageSha256Condition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_FINGERPRINT = 0x2L;
    private static final long INIT_BIT_FINGERPRINT_BASE64_URL = 0x4L;
    private static final long INIT_BIT_COST = 0x8L;
    private long initBits = 0xfL;

    private CryptoConditionType type;
    private byte[] fingerprint;
    private String fingerprintBase64Url;
    private long cost;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.Condition} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Condition instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.PreimageSha256Condition.AbstractPreimageSha256Condition} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PreimageSha256Condition.AbstractPreimageSha256Condition instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Condition) {
        Condition instance = (Condition) object;
        fingerprint(instance.getFingerprint());
        fingerprintBase64Url(instance.getFingerprintBase64Url());
        cost(instance.getCost());
        type(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(CryptoConditionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getFingerprint() fingerprint} attribute.
     * @param fingerprint The elements for fingerprint
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder fingerprint(byte... fingerprint) {
      this.fingerprint = fingerprint.clone();
      initBits &= ~INIT_BIT_FINGERPRINT;
      return this;
    }

    /**
     * Initializes the value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getFingerprintBase64Url() fingerprintBase64Url} attribute.
     * @param fingerprintBase64Url The value for fingerprintBase64Url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fingerprintBase64Url(String fingerprintBase64Url) {
      this.fingerprintBase64Url = Objects.requireNonNull(fingerprintBase64Url, "fingerprintBase64Url");
      initBits &= ~INIT_BIT_FINGERPRINT_BASE64_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link PreimageSha256Condition.AbstractPreimageSha256Condition#getCost() cost} attribute.
     * @param cost The value for cost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cost(long cost) {
      this.cost = cost;
      initBits &= ~INIT_BIT_COST;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePreimageSha256Condition ImmutablePreimageSha256Condition}.
     * @return An immutable instance of PreimageSha256Condition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePreimageSha256Condition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePreimageSha256Condition(type, fingerprint, fingerprintBase64Url, cost);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_FINGERPRINT) != 0) attributes.add("fingerprint");
      if ((initBits & INIT_BIT_FINGERPRINT_BASE64_URL) != 0) attributes.add("fingerprintBase64Url");
      if ((initBits & INIT_BIT_COST) != 0) attributes.add("cost");
      return "Cannot build PreimageSha256Condition, some of required attributes are not set " + attributes;
    }
  }
}
