package com.ripple.cryptoconditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrefixSha256Fulfillment.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment"})
public final class ImmutablePrefixSha256Fulfillment
    extends PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment {
  private final byte[] prefix;
  private final String prefixBase64Url;
  private final long maxMessageLength;
  private final Fulfillment subfulfillment;
  private final CryptoConditionType type;
  private final PrefixSha256Condition derivedCondition;

  private ImmutablePrefixSha256Fulfillment(
      byte[] prefix,
      String prefixBase64Url,
      long maxMessageLength,
      Fulfillment subfulfillment,
      CryptoConditionType type,
      PrefixSha256Condition derivedCondition) {
    this.prefix = prefix;
    this.prefixBase64Url = prefixBase64Url;
    this.maxMessageLength = maxMessageLength;
    this.subfulfillment = subfulfillment;
    this.type = type;
    this.derivedCondition = derivedCondition;
  }

  /**
   * Accessor for the prefix as an array from bytes.
   * @return A byte array containing the prefix for this fulfillment.
   * @deprecated Java 8 does not have the concept from an immutable byte array, so this method allows external callers
   *     to accidentally or intentionally mutate the prefix. As such, this method may be removed in a future version.
   *     Prefer {@link #getPrefixBase64Url()} instead.
   */
  @Deprecated
  @Override
  public byte[] getPrefix() {
    return prefix.clone();
  }

  /**
   * Accessor for the prefix as a Base64Url-encoded String.
   * @return A {@link String} containing Base64Url characters.
   */
  @Override
  public String getPrefixBase64Url() {
    return prefixBase64Url;
  }

  /**
   * <p>Accessor for the maximum message length, which per the spec is the maximum size that a given prefix
   * fulfillment will allow in order validate a given condition against this fulfillment.</p>
   * <p>More specifically, the spec says that a A PREFIX-SHA-256 fulfillment is valid iff, "The size of M (the
   * message), in bytes, is less than or equal to F.maxMessageLength...".</p>
   * @return The maximum message length supported by a prefix fulfillment.
   */
  @Override
  public long getMaxMessageLength() {
    return maxMessageLength;
  }

  /**
   * @return The value of the {@code subfulfillment} attribute
   */
  @Override
  public Fulfillment getSubfulfillment() {
    return subfulfillment;
  }

  /**
   * Accessor for the type of this fulfillment.
   * @return A {@link CryptoConditionType} for this fulfillment.
   */
  @Override
  public CryptoConditionType getType() {
    return type;
  }

  /**
   * Accessor for the condition that corresponds to this fulfillment.
   * @return A {@link Condition} that can be fulfilled by this fulfillment.
   */
  @Override
  public PrefixSha256Condition getDerivedCondition() {
    return derivedCondition;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getPrefix() prefix}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for prefix
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutablePrefixSha256Fulfillment withPrefix(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutablePrefixSha256Fulfillment(
        newValue,
        this.prefixBase64Url,
        this.maxMessageLength,
        this.subfulfillment,
        this.type,
        this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getPrefixBase64Url() prefixBase64Url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prefixBase64Url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrefixSha256Fulfillment withPrefixBase64Url(String value) {
    if (this.prefixBase64Url.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "prefixBase64Url");
    return new ImmutablePrefixSha256Fulfillment(
        this.prefix,
        newValue,
        this.maxMessageLength,
        this.subfulfillment,
        this.type,
        this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getMaxMessageLength() maxMessageLength} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxMessageLength
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrefixSha256Fulfillment withMaxMessageLength(long value) {
    if (this.maxMessageLength == value) return this;
    return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, value, this.subfulfillment, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getSubfulfillment() subfulfillment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subfulfillment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrefixSha256Fulfillment withSubfulfillment(Fulfillment value) {
    if (this.subfulfillment == value) return this;
    Fulfillment newValue = Objects.requireNonNull(value, "subfulfillment");
    return new ImmutablePrefixSha256Fulfillment(
        this.prefix,
        this.prefixBase64Url,
        this.maxMessageLength,
        newValue,
        this.type,
        this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrefixSha256Fulfillment withType(CryptoConditionType value) {
    if (this.type == value) return this;
    CryptoConditionType newValue = Objects.requireNonNull(value, "type");
    return new ImmutablePrefixSha256Fulfillment(
        this.prefix,
        this.prefixBase64Url,
        this.maxMessageLength,
        this.subfulfillment,
        newValue,
        this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for derivedCondition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrefixSha256Fulfillment withDerivedCondition(PrefixSha256Condition value) {
    if (this.derivedCondition == value) return this;
    PrefixSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
    return new ImmutablePrefixSha256Fulfillment(
        this.prefix,
        this.prefixBase64Url,
        this.maxMessageLength,
        this.subfulfillment,
        this.type,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrefixSha256Fulfillment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrefixSha256Fulfillment
        && equalTo((ImmutablePrefixSha256Fulfillment) another);
  }

  private boolean equalTo(ImmutablePrefixSha256Fulfillment another) {
    return Arrays.equals(prefix, another.prefix)
        && prefixBase64Url.equals(another.prefixBase64Url)
        && maxMessageLength == another.maxMessageLength
        && subfulfillment.equals(another.subfulfillment)
        && type.equals(another.type)
        && derivedCondition.equals(another.derivedCondition);
  }

  /**
   * Computes a hash code from attributes: {@code prefix}, {@code prefixBase64Url}, {@code maxMessageLength}, {@code subfulfillment}, {@code type}, {@code derivedCondition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(prefix);
    h += (h << 5) + prefixBase64Url.hashCode();
    h += (h << 5) + Long.hashCode(maxMessageLength);
    h += (h << 5) + subfulfillment.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + derivedCondition.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrefixSha256Fulfillment instance
   */
  public static ImmutablePrefixSha256Fulfillment copyOf(PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment instance) {
    if (instance instanceof ImmutablePrefixSha256Fulfillment) {
      return (ImmutablePrefixSha256Fulfillment) instance;
    }
    return ImmutablePrefixSha256Fulfillment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrefixSha256Fulfillment ImmutablePrefixSha256Fulfillment}.
   * @return A new ImmutablePrefixSha256Fulfillment builder
   */
  public static ImmutablePrefixSha256Fulfillment.Builder builder() {
    return new ImmutablePrefixSha256Fulfillment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrefixSha256Fulfillment ImmutablePrefixSha256Fulfillment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PREFIX = 0x1L;
    private static final long INIT_BIT_PREFIX_BASE64_URL = 0x2L;
    private static final long INIT_BIT_MAX_MESSAGE_LENGTH = 0x4L;
    private static final long INIT_BIT_SUBFULFILLMENT = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_DERIVED_CONDITION = 0x20L;
    private long initBits = 0x3fL;

    private byte[] prefix;
    private String prefixBase64Url;
    private long maxMessageLength;
    private Fulfillment subfulfillment;
    private CryptoConditionType type;
    private PrefixSha256Condition derivedCondition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.PrefixSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PrefixSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PrefixSha256Fulfillment) {
        PrefixSha256Fulfillment instance = (PrefixSha256Fulfillment) object;
        prefixBase64Url(instance.getPrefixBase64Url());
        subfulfillment(instance.getSubfulfillment());
        prefix(instance.getPrefix());
        maxMessageLength(instance.getMaxMessageLength());
      }
      if (object instanceof PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment) {
        PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment instance = (PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment) object;
        type(instance.getType());
        derivedCondition(instance.getDerivedCondition());
      }
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getPrefix() prefix} attribute.
     * @param prefix The elements for prefix
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder prefix(byte... prefix) {
      this.prefix = prefix.clone();
      initBits &= ~INIT_BIT_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getPrefixBase64Url() prefixBase64Url} attribute.
     * @param prefixBase64Url The value for prefixBase64Url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder prefixBase64Url(String prefixBase64Url) {
      this.prefixBase64Url = Objects.requireNonNull(prefixBase64Url, "prefixBase64Url");
      initBits &= ~INIT_BIT_PREFIX_BASE64_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getMaxMessageLength() maxMessageLength} attribute.
     * @param maxMessageLength The value for maxMessageLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxMessageLength(long maxMessageLength) {
      this.maxMessageLength = maxMessageLength;
      initBits &= ~INIT_BIT_MAX_MESSAGE_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getSubfulfillment() subfulfillment} attribute.
     * @param subfulfillment The value for subfulfillment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subfulfillment(Fulfillment subfulfillment) {
      this.subfulfillment = Objects.requireNonNull(subfulfillment, "subfulfillment");
      initBits &= ~INIT_BIT_SUBFULFILLMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(CryptoConditionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
     * @param derivedCondition The value for derivedCondition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder derivedCondition(PrefixSha256Condition derivedCondition) {
      this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
      initBits &= ~INIT_BIT_DERIVED_CONDITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrefixSha256Fulfillment ImmutablePrefixSha256Fulfillment}.
     * @return An immutable instance of PrefixSha256Fulfillment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrefixSha256Fulfillment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePrefixSha256Fulfillment(prefix, prefixBase64Url, maxMessageLength, subfulfillment, type, derivedCondition);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PREFIX) != 0) attributes.add("prefix");
      if ((initBits & INIT_BIT_PREFIX_BASE64_URL) != 0) attributes.add("prefixBase64Url");
      if ((initBits & INIT_BIT_MAX_MESSAGE_LENGTH) != 0) attributes.add("maxMessageLength");
      if ((initBits & INIT_BIT_SUBFULFILLMENT) != 0) attributes.add("subfulfillment");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_DERIVED_CONDITION) != 0) attributes.add("derivedCondition");
      return "Cannot build PrefixSha256Fulfillment, some of required attributes are not set " + attributes;
    }
  }
}
