package com.ripple.cryptoconditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import net.i2p.crypto.eddsa.EdDSAPublicKey;

/**
 * Immutable implementation of {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEd25519Sha256Fulfillment.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment"})
public final class ImmutableEd25519Sha256Fulfillment
    extends Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment {
  private final EdDSAPublicKey publicKey;
  private final byte[] signature;
  private final String signatureBase64Url;
  private final CryptoConditionType type;
  private final Ed25519Sha256Condition derivedCondition;

  private ImmutableEd25519Sha256Fulfillment(
      EdDSAPublicKey publicKey,
      byte[] signature,
      String signatureBase64Url,
      CryptoConditionType type,
      Ed25519Sha256Condition derivedCondition) {
    this.publicKey = publicKey;
    this.signature = signature;
    this.signatureBase64Url = signatureBase64Url;
    this.type = type;
    this.derivedCondition = derivedCondition;
  }

  /**
   * Returns the public key used.
   * @return The {@link EdDSAPublicKey} for this fulfillment.
   */
  @Override
  public EdDSAPublicKey getPublicKey() {
    return publicKey;
  }

  /**
   * Returns a copy from the signature linked to this fulfillment.
   * @return A byte array containing the signature for this fulfillment.
   * @deprecated Java 8 does not have the concept from an immutable byte array, so this method allows external callers
   *     to accidentally or intentionally mute the prefix. As such, this method may be removed in a future version.
   *     Prefer {@link #getSignatureBase64Url()} instead.
   */
  @Deprecated
  @Override
  public byte[] getSignature() {
    return signature.clone();
  }

  /**
   * Returns a copy from the signature linked to this fulfillment.
   * @return A {@link String} containing the Base64Url-encoded signature for this fulfillment.
   */
  @Override
  public String getSignatureBase64Url() {
    return signatureBase64Url;
  }

  /**
   * Accessor for the type of this fulfillment.
   * @return A {@link CryptoConditionType} for this fulfillment.
   */
  @Override
  public CryptoConditionType getType() {
    return type;
  }

  /**
   * Accessor for the condition that corresponds to this fulfillment.
   * @return A {@link Condition} that can be fulfilled by this fulfillment.
   */
  @Override
  public Ed25519Sha256Condition getDerivedCondition() {
    return derivedCondition;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getPublicKey() publicKey} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for publicKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEd25519Sha256Fulfillment withPublicKey(EdDSAPublicKey value) {
    if (this.publicKey == value) return this;
    EdDSAPublicKey newValue = Objects.requireNonNull(value, "publicKey");
    return new ImmutableEd25519Sha256Fulfillment(newValue, this.signature, this.signatureBase64Url, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getSignature() signature}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for signature
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final ImmutableEd25519Sha256Fulfillment withSignature(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableEd25519Sha256Fulfillment(this.publicKey, newValue, this.signatureBase64Url, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getSignatureBase64Url() signatureBase64Url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signatureBase64Url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEd25519Sha256Fulfillment withSignatureBase64Url(String value) {
    if (this.signatureBase64Url.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "signatureBase64Url");
    return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, newValue, this.type, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEd25519Sha256Fulfillment withType(CryptoConditionType value) {
    if (this.type == value) return this;
    CryptoConditionType newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, newValue, this.derivedCondition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for derivedCondition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEd25519Sha256Fulfillment withDerivedCondition(Ed25519Sha256Condition value) {
    if (this.derivedCondition == value) return this;
    Ed25519Sha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
    return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEd25519Sha256Fulfillment} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEd25519Sha256Fulfillment
        && equalTo((ImmutableEd25519Sha256Fulfillment) another);
  }

  private boolean equalTo(ImmutableEd25519Sha256Fulfillment another) {
    return publicKey.equals(another.publicKey)
        && Arrays.equals(signature, another.signature)
        && signatureBase64Url.equals(another.signatureBase64Url)
        && type.equals(another.type)
        && derivedCondition.equals(another.derivedCondition);
  }

  /**
   * Computes a hash code from attributes: {@code publicKey}, {@code signature}, {@code signatureBase64Url}, {@code type}, {@code derivedCondition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + publicKey.hashCode();
    h += (h << 5) + Arrays.hashCode(signature);
    h += (h << 5) + signatureBase64Url.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + derivedCondition.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Ed25519Sha256Fulfillment instance
   */
  public static ImmutableEd25519Sha256Fulfillment copyOf(Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment instance) {
    if (instance instanceof ImmutableEd25519Sha256Fulfillment) {
      return (ImmutableEd25519Sha256Fulfillment) instance;
    }
    return ImmutableEd25519Sha256Fulfillment.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEd25519Sha256Fulfillment ImmutableEd25519Sha256Fulfillment}.
   * @return A new ImmutableEd25519Sha256Fulfillment builder
   */
  public static ImmutableEd25519Sha256Fulfillment.Builder builder() {
    return new ImmutableEd25519Sha256Fulfillment.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEd25519Sha256Fulfillment ImmutableEd25519Sha256Fulfillment}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PUBLIC_KEY = 0x1L;
    private static final long INIT_BIT_SIGNATURE = 0x2L;
    private static final long INIT_BIT_SIGNATURE_BASE64_URL = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_DERIVED_CONDITION = 0x10L;
    private long initBits = 0x1fL;

    private EdDSAPublicKey publicKey;
    private byte[] signature;
    private String signatureBase64Url;
    private CryptoConditionType type;
    private Ed25519Sha256Condition derivedCondition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.ripple.cryptoconditions.Ed25519Sha256Fulfillment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Ed25519Sha256Fulfillment instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment) {
        Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment instance = (Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment) object;
        type(instance.getType());
        derivedCondition(instance.getDerivedCondition());
      }
      if (object instanceof Ed25519Sha256Fulfillment) {
        Ed25519Sha256Fulfillment instance = (Ed25519Sha256Fulfillment) object;
        signature(instance.getSignature());
        signatureBase64Url(instance.getSignatureBase64Url());
        publicKey(instance.getPublicKey());
      }
    }

    /**
     * Initializes the value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getPublicKey() publicKey} attribute.
     * @param publicKey The value for publicKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder publicKey(EdDSAPublicKey publicKey) {
      this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
      initBits &= ~INIT_BIT_PUBLIC_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getSignature() signature} attribute.
     * @param signature The elements for signature
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder signature(byte... signature) {
      this.signature = signature.clone();
      initBits &= ~INIT_BIT_SIGNATURE;
      return this;
    }

    /**
     * Initializes the value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getSignatureBase64Url() signatureBase64Url} attribute.
     * @param signatureBase64Url The value for signatureBase64Url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder signatureBase64Url(String signatureBase64Url) {
      this.signatureBase64Url = Objects.requireNonNull(signatureBase64Url, "signatureBase64Url");
      initBits &= ~INIT_BIT_SIGNATURE_BASE64_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(CryptoConditionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment#getDerivedCondition() derivedCondition} attribute.
     * @param derivedCondition The value for derivedCondition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder derivedCondition(Ed25519Sha256Condition derivedCondition) {
      this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
      initBits &= ~INIT_BIT_DERIVED_CONDITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEd25519Sha256Fulfillment ImmutableEd25519Sha256Fulfillment}.
     * @return An immutable instance of Ed25519Sha256Fulfillment
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEd25519Sha256Fulfillment build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEd25519Sha256Fulfillment(publicKey, signature, signatureBase64Url, type, derivedCondition);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PUBLIC_KEY) != 0) attributes.add("publicKey");
      if ((initBits & INIT_BIT_SIGNATURE) != 0) attributes.add("signature");
      if ((initBits & INIT_BIT_SIGNATURE_BASE64_URL) != 0) attributes.add("signatureBase64Url");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_DERIVED_CONDITION) != 0) attributes.add("derivedCondition");
      return "Cannot build Ed25519Sha256Fulfillment, some of required attributes are not set " + attributes;
    }
  }
}
