/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.APICallPreHandler;
import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.LoggingManager;
import com.paypal.core.SDKUtil;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.OAuthTokenCredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.RESTAPICallPreHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayPalResource {
    private static Map<String, String> configurationMap;
    private static boolean configInitialized;
    private static final ThreadLocal<String> LASTREQUEST;
    private static final ThreadLocal<String> LASTRESPONSE;

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + file.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(file);
            return PayPalResource.initConfig(fis);
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, ioe.getMessage(), ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        configurationMap = SDKUtil.constructMap(properties);
        configInitialized = true;
        return PayPalResource.getOAuthTokenCredential();
    }

    public static OAuthTokenCredential initConfig(InputStream inputStream) throws PayPalRESTException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            configurationMap = SDKUtil.constructMap(properties);
            configInitialized = true;
            return PayPalResource.getOAuthTokenCredential();
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, ioe.getMessage(), ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static String getClientID() {
        return configurationMap.get("clientId");
    }

    public static String getClientSecret() {
        return configurationMap.get("clientSecret");
    }

    public static OAuthTokenCredential getOAuthTokenCredential() {
        if (configInitialized) {
            return new OAuthTokenCredential(PayPalResource.getClientID(), PayPalResource.getClientSecret(), configurationMap);
        }
        return new OAuthTokenCredential(PayPalResource.getClientID(), PayPalResource.getClientSecret());
    }

    public static void initializeToDefault() throws PayPalRESTException {
        configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
    }

    public static String getLastRequest() {
        return LASTREQUEST.get();
    }

    public static String getLastResponse() {
        return LASTRESPONSE.get();
    }

    public static <T> T configureAndExecute(String accessToken, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        return PayPalResource.configureAndExecute(null, accessToken, httpMethod, resourcePath, null, payLoad, null, clazz);
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        if (apiContext != null) {
            Map<String, String> cMap;
            if (apiContext.getConfigurationMap() != null) {
                cMap = SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            } else {
                if (!configInitialized) {
                    PayPalResource.initializeToDefault();
                }
                cMap = new HashMap<String, String>(configurationMap);
            }
            Map<String, String> headersMap = apiContext.getHTTPHeaders();
            String accessToken = apiContext.getAccessToken();
            String requestId = apiContext.getRequestId();
            APICallPreHandler apiCallPreHandler = PayPalResource.createAPICallPreHandler(cMap, payLoad, resourcePath, headersMap, accessToken, requestId, apiContext.getSdkVersion());
            HttpConfiguration httpConfiguration = PayPalResource.createHttpConfiguration(cMap, httpMethod, apiCallPreHandler);
            t = PayPalResource.execute(apiCallPreHandler, httpConfiguration, clazz);
        }
        return t;
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, Class<T> clazz) throws PayPalRESTException {
        Map<String, String> cMap = null;
        String accessToken = null;
        String requestId = null;
        if (apiContext != null) {
            cMap = apiContext.getConfigurationMap();
            accessToken = apiContext.getAccessToken();
            requestId = apiContext.getRequestId();
        }
        return PayPalResource.configureAndExecute(cMap, accessToken, httpMethod, resourcePath, headersMap, payLoad, requestId, clazz);
    }

    private static <T> T configureAndExecute(Map<String, String> configurationMap, String accessToken, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, String requestId, Class<T> clazz) throws PayPalRESTException {
        Map<String, String> cMap;
        if (configurationMap != null) {
            cMap = SDKUtil.combineDefaultMap(configurationMap);
        } else {
            if (!configInitialized) {
                PayPalResource.initializeToDefault();
            }
            cMap = new HashMap<String, String>(PayPalResource.configurationMap);
        }
        APICallPreHandler apiCallPreHandler = PayPalResource.createAPICallPreHandler(cMap, payLoad, resourcePath, headersMap, accessToken, requestId, null);
        HttpConfiguration httpConfiguration = PayPalResource.createHttpConfiguration(cMap, httpMethod, apiCallPreHandler);
        T t = PayPalResource.execute(apiCallPreHandler, httpConfiguration, clazz);
        return t;
    }

    public static APICallPreHandler createAPICallPreHandler(Map<String, String> configurationMap, String payLoad, String resourcePath, Map<String, String> headersMap, String accessToken, String requestId, SDKVersion sdkVersion) {
        RESTAPICallPreHandler restAPICallPreHandler = new RESTAPICallPreHandler(configurationMap, headersMap);
        restAPICallPreHandler.setResourcePath(resourcePath);
        restAPICallPreHandler.setRequestId(requestId);
        restAPICallPreHandler.setAuthorizationToken(accessToken);
        restAPICallPreHandler.setPayLoad(payLoad);
        restAPICallPreHandler.setSdkVersion(sdkVersion);
        RESTAPICallPreHandler apiCallPreHandler = restAPICallPreHandler;
        return apiCallPreHandler;
    }

    private static <T> T execute(APICallPreHandler apiCallPreHandler, HttpConfiguration httpConfiguration, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        try {
            Map<String, String> headers = apiCallPreHandler.getHeaderMap();
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            HttpConnection httpConnection = connectionManager.getConnection(httpConfiguration);
            httpConnection.createAndconfigureHttpConnection(httpConfiguration);
            LASTREQUEST.set(apiCallPreHandler.getPayLoad());
            String responseString = httpConnection.execute(null, apiCallPreHandler.getPayLoad(), headers);
            LASTRESPONSE.set(responseString);
            if (clazz != null) {
                t = JSONFormatter.fromJSON(responseString, clazz);
            }
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return t;
    }

    private static HttpConfiguration createHttpConfiguration(Map<String, String> configurationMap, HttpMethod httpMethod, APICallPreHandler apiCallPreHandler) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod(httpMethod.toString());
        httpConfiguration.setEndPointUrl(apiCallPreHandler.getEndPoint());
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(configurationMap.get("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxyPort(Integer.parseInt(configurationMap.get("http.ProxyPort")));
            httpConfiguration.setProxyHost(configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyUserName(configurationMap.get("http.ProxyUserName"));
            httpConfiguration.setProxyPassword(configurationMap.get("http.ProxyPassword"));
        }
        httpConfiguration.setConnectionTimeout(Integer.parseInt(configurationMap.get("http.ConnectionTimeOut")));
        httpConfiguration.setMaxRetry(Integer.parseInt(configurationMap.get("http.Retry")));
        httpConfiguration.setReadTimeout(Integer.parseInt(configurationMap.get("http.ReadTimeOut")));
        httpConfiguration.setMaxHttpConnection(Integer.parseInt(configurationMap.get("http.MaxConnection")));
        httpConfiguration.setIpAddress(configurationMap.get("http.IPAddress"));
        return httpConfiguration;
    }

    static {
        configInitialized = false;
        LASTREQUEST = new ThreadLocal();
        LASTRESPONSE = new ThreadLocal();
    }
}

