/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http.serializer;

import com.paypal.http.HttpRequest;
import com.paypal.http.exceptions.SerializeException;
import com.paypal.http.multipart.FormData;
import com.paypal.http.multipart.MultipartBody;
import com.paypal.http.serializer.Serializer;
import com.paypal.http.serializer.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Multipart
implements Serializer {
    public static final String CRLF = "\r\n";

    @Override
    public String contentType() {
        return "^multipart\\/.*";
    }

    @Override
    public byte[] encode(HttpRequest request) throws IOException {
        if (!(request.requestBody() instanceof MultipartBody)) {
            throw new SerializeException("Request requestBody must be MultipartBody when Content-Type is multipart/*");
        }
        String contentType = request.headers().header("content-type");
        String boundary = "boundary" + System.currentTimeMillis();
        contentType = contentType + "; boundary=" + boundary;
        request.header("content-type", contentType);
        MultipartBody body = (MultipartBody)request.requestBody();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (FormData formData : body) {
            this.writePart(os, formData, boundary);
        }
        StreamUtils.writeOutputStream((OutputStream)os, "--" + boundary + "--");
        StreamUtils.writeOutputStream((OutputStream)os, CRLF);
        StreamUtils.writeOutputStream((OutputStream)os, CRLF);
        return os.toByteArray();
    }

    @Override
    public <T> T decode(String source, Class<T> cls) throws IOException {
        throw new UnsupportedEncodingException("Unable to decode Content-Type: multipart/form-data.");
    }

    private void writePart(OutputStream writer, FormData part, String boundary) throws IOException {
        StreamUtils.writeOutputStream(writer, "--" + boundary);
        StreamUtils.writeOutputStream(writer, CRLF);
        StreamUtils.writeOutputStream(writer, part.header());
        StreamUtils.writeOutputStream(writer, CRLF);
        StreamUtils.writeOutputStream(writer, CRLF);
        part.writeData(writer);
        StreamUtils.writeOutputStream(writer, CRLF);
    }
}

