/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12CRLBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private CRL crl;
    private ASN1Sequence contents;

    public PKCS12CRLBag() {
    }

    public PKCS12CRLBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12CRLBag(PKCS12Safe parent, CRL crl) {
        this(parent);
        this.crl = crl;
    }

    public PKCS12CRLBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12CRLBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed bc = (ASN1GenericConstructed)s.elementAt(1);
            ASN1Sequence cb = (ASN1Sequence)bc.elementAt(0);
            ASN1ObjectID ct = (ASN1ObjectID)cb.elementAt(0);
            if (!ct.equals(ASN1Utils.pkcsID, 9, 23, 1)) {
                throw new IOException("Unsupported CRL type " + ct);
            }
            ASN1GenericConstructed c = (ASN1GenericConstructed)cb.elementAt(1);
            this.crl = new CRL((InputStream)new UnsyncByteArrayInputStream(((ASN1OctetString)c.elementAt(0)).getValue()));
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4));
        ASN1Sequence cb = new ASN1Sequence();
        cb.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 9, 23, 1));
        cb.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(Utils.toBytes((Streamable)this.crl)), 0));
        s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)cb, 0));
        ASN1Set attr = this.outputAttrsASN1();
        if (attr != null) {
            s.addElement((ASN1Object)attr);
        }
        this.contents = s;
        return s;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public CRL getCRL() {
        return this.crl;
    }

    public void setCRL(CRL crl) {
        this.crl = crl;
        this.reset();
    }

    public String toString() {
        String s = "";
        if (this.friendlyName != null) {
            s = s + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            s = s + "localKeyID = " + Utils.toHexString((byte[])this.localKeyID) + ", ";
        }
        return s + this.crl.toString();
    }
}

