/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeSet
implements ASN1Object,
Cloneable,
Externalizable {
    private Hashtable attributes;
    private ASN1Set contents;

    public AttributeSet() {
        this.attributes = new Hashtable();
    }

    public AttributeSet(InputStream is) throws IOException {
        this.input(is);
    }

    public Attribute addAttribute(Attribute attr) {
        this.update();
        return this.attributes.put(attr.getType(), attr);
    }

    public Attribute addAttribute(ASN1ObjectID type, ASN1Object value) {
        return this.addAttribute(new Attribute(type, value));
    }

    public Attribute addAttribute(ASN1ObjectID type, Vector values) {
        return this.addAttribute(new Attribute(type, values));
    }

    public Attribute getAttribute(ASN1ObjectID type) {
        if (this.hasAttribute(type)) {
            return (Attribute)this.attributes.get(type);
        }
        return null;
    }

    public void addAttributeValue(ASN1ObjectID type, ASN1Object value) {
        Attribute a = this.getAttribute(type);
        if (a != null) {
            a.addValue(value);
        } else {
            this.addAttribute(type, value);
        }
    }

    public Vector getAttributeValues(ASN1ObjectID type) {
        Attribute a = this.getAttribute(type);
        return a != null ? a.getValues() : null;
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID type) {
        return this.attributes.containsKey(type);
    }

    public Enumeration types() {
        return this.attributes.keys();
    }

    public Object clone() {
        AttributeSet a = new AttributeSet();
        a.attributes = (Hashtable)this.attributes.clone();
        return a;
    }

    public String toString() {
        String s = "{";
        Enumeration e = this.types();
        while (e.hasMoreElements()) {
            s = s + " " + e.nextElement();
            if (!e.hasMoreElements()) continue;
            s = s + ",";
        }
        s = s + " }";
        return s;
    }

    public void input(InputStream is) throws IOException {
        this.attributes = new Hashtable();
        ASN1SetInputStream sis = new ASN1SetInputStream(is);
        while (sis.hasMoreData()) {
            Attribute attr = new Attribute((InputStream)sis);
            this.attributes.put(attr.getType(), attr);
        }
        sis.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Set().output(os);
    }

    public int length() {
        return this.toASN1Set().length();
    }

    private void update() {
        this.contents = null;
    }

    public ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set s = new ASN1Set();
            Enumeration e = this.types();
            while (e.hasMoreElements()) {
                s.addElement((ASN1Object)((Attribute)this.attributes.get((ASN1ObjectID)e.nextElement())));
            }
            this.contents = s;
        }
        return this.contents;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

