/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.UCPDataSourceResource;
import oracle.ucp.jdbc.UCPResource;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class UCPServletContextListener
implements ServletContextListener {
    private PoolDataSource pds;
    private InitialContext initContext;
    private UniversalConnectionPoolManagerMBean managerMBean;
    static final String loggerName = "oracle.ucp.jdbc";
    private static final Logger logger;
    @Inject
    @UCPResource
    private UCPDataSourceResource ucpDataSourceResource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.initializeUCPDataSourceResource(context);
        if (this.ucpDataSourceResource == null) {
            return;
        }
        try {
            this.configureUCPDataSource(context);
            if (this.pds == null || this.pds.getURL() == null || this.pds.getConnectionFactoryClassName() == null || "".equals(this.pds.getConnectionFactoryClassName())) {
                this.pds = null;
                return;
            }
            this.startPool();
            this.ucpDataSourceResource.setPoolDataSource(this.pds);
            this.bindUCPDatasourceResource(context);
        }
        catch (SQLException | NamingException | UniversalConnectionPoolException exception) {
            logger.severe(exception.getMessage());
            this.cleanupPool();
        }
        catch (Throwable exception) {
            logger.severe("Error occurred while creating UCP pool : " + exception.getMessage());
            this.cleanupPool();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.removeBinding(context);
        this.cleanupPool();
    }

    private void initializeUCPDataSourceResource(ServletContext context) {
        if (this.ucpDataSourceResource == null && context.getInitParameter("ucp.jndiName") != null) {
            this.ucpDataSourceResource = new UCPDataSourceResource();
        }
    }

    private void configureUCPDataSource(ServletContext context) throws SQLException {
        if (System.getProperty("oracle.ucp.jdbc.xmlConfigFile") != null && context.getInitParameter("ucp.dataSourceNameFromXMLConfig") != null) {
            this.pds = PoolDataSourceFactory.getPoolDataSource(context.getInitParameter("ucp.dataSourceNameFromXMLConfig"));
        } else {
            this.pds = PoolDataSourceFactory.getPoolDataSource();
            Enumeration parameterNames = context.getInitParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                try {
                    Class parameterType = null;
                    Object value = null;
                    switch (parameter) {
                        case "ucp.connectionPoolName": 
                        case "ucp.connectionFactoryClassName": 
                        case "ucp.URL": 
                        case "ucp.user": 
                        case "ucp.password": 
                        case "ucp.serverName": 
                        case "ucp.databaseName": 
                        case "ucp.dataSourceName": 
                        case "ucp.description": 
                        case "ucp.networkProtocol": 
                        case "ucp.roleName": 
                        case "ucp.sqlForValidateConnection": 
                        case "ucp.onsConfiguration": {
                            parameterType = String.class;
                            value = context.getInitParameter(parameter);
                            break;
                        }
                        case "ucp.portNumber": 
                        case "ucp.initialPoolSize": 
                        case "ucp.maxPoolSize": 
                        case "ucp.minPoolSize": 
                        case "ucp.abandonedConnectionTimeout": 
                        case "ucp.timeToLiveConnectionTimeout": 
                        case "ucp.inactiveConnectionTimeout": 
                        case "ucp.maxIdleTime": 
                        case "ucp.timeoutCheckInterval": 
                        case "ucp.propertyCycle": 
                        case "ucp.maxStatements": 
                        case "ucp.connectionWaitTimeout": 
                        case "ucp.maxConnectionReuseCount": 
                        case "ucp.connectionHarvestTriggerCount": 
                        case "ucp.connectionHarvestMaxCount": 
                        case "ucp.secondsToTrustIdleConnection": 
                        case "ucp.connectionLabelingHighCost": 
                        case "ucp.connectionRepurposeThreshold": 
                        case "ucp.highCostConnectionReuseThreshold": 
                        case "ucp.maxConnectionsPerShard": 
                        case "ucp.connectionValidationTimeout": {
                            parameterType = Integer.TYPE;
                            value = Integer.valueOf(context.getInitParameter(parameter));
                            break;
                        }
                        case "ucp.maxConnectionReuseTime": {
                            parameterType = Long.TYPE;
                            value = Long.valueOf(context.getInitParameter(parameter));
                            break;
                        }
                        case "ucp.validateConnectionOnBorrow": 
                        case "ucp.fastConnectionFailoverEnabled": 
                        case "ucp.shardingMode": {
                            parameterType = Boolean.TYPE;
                            value = Boolean.valueOf(context.getInitParameter(parameter));
                        }
                    }
                    if (parameterType == null) continue;
                    PoolDataSource.class.getMethod("set" + parameter.substring(4, 5).toUpperCase() + parameter.substring(5), parameterType).invoke((Object)this.pds, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    logger.severe(exception.getMessage());
                }
                catch (Throwable t) {
                    logger.warning("Error occurred while setting UCP pool datasource property : " + parameter + " Error : " + t.getMessage());
                }
            }
        }
    }

    private void startPool() throws UniversalConnectionPoolException {
        this.managerMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
        this.managerMBean.createConnectionPool((UniversalConnectionPoolAdapter)((Object)this.pds));
        this.managerMBean.startConnectionPool(this.pds.getConnectionPoolName());
    }

    private void bindUCPDatasourceResource(ServletContext context) throws NamingException {
        if (context.getInitParameter("ucp.jndiName") != null) {
            this.initContext = new InitialContext();
            this.initContext.bind(context.getInitParameter("ucp.jndiName"), (Object)this.ucpDataSourceResource);
        }
    }

    private void removeBinding(ServletContext context) {
        String ucpJndiName = context.getInitParameter("ucp.jndiName");
        if (this.initContext != null && ucpJndiName != null) {
            try {
                this.initContext.unbind(ucpJndiName);
            }
            catch (NamingException e) {
                logger.finest(e.getMessage());
            }
        }
    }

    private void cleanupPool() {
        try {
            if (this.managerMBean == null || this.pds == null) {
                return;
            }
            this.managerMBean.stopConnectionPool(this.pds.getConnectionPoolName());
            this.managerMBean.destroyConnectionPool(this.pds.getConnectionPoolName());
        }
        catch (Throwable exception) {
            logger.finest(exception.getMessage());
        }
        finally {
            this.pds = null;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = UCPServletContextListener.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = UCPServletContextListener.class.getDeclaredMethod("cleanupPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UCPServletContextListener.class.getDeclaredMethod("removeBinding", ServletContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UCPServletContextListener.class.getDeclaredMethod("bindUCPDatasourceResource", ServletContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UCPServletContextListener.class.getDeclaredMethod("startPool", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UCPServletContextListener.class.getDeclaredMethod("configureUCPDataSource", ServletContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UCPServletContextListener.class.getDeclaredMethod("initializeUCPDataSourceResource", ServletContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UCPServletContextListener.class.getDeclaredMethod("contextDestroyed", ServletContextEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UCPServletContextListener.class.getDeclaredMethod("contextInitialized", ServletContextEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
    }
}

