/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.rsi.internal.MetadataImpl;
import oracle.sql.CharacterSet;
import oracle.sql.ZONEIDMAP;

interface Metadata {
    public static final int DB_TYPE_VARCHAR2 = 1;
    public static final int DB_TYPE_NUMBER = 2;
    public static final int DB_TYPE_VNUM = 6;
    public static final int DB_TYPE_LONG = 8;
    public static final int DB_TYPE_DATE = 12;
    public static final int DB_TYPE_FLOAT = 21;
    public static final int DB_TYPE_RAW = 23;
    public static final int DB_TYPE_ROWID = 69;
    public static final int DB_TYPE_CHAR = 96;
    public static final int DB_TYPE_BINARY_FLOAT = 100;
    public static final int DB_TYPE_BINARY_DOUBLE = 101;
    public static final int DB_TYPE_CLOB = 112;
    public static final int DB_TYPE_BLOB = 113;
    public static final int DB_TYPE_JSON = 119;
    public static final int DB_TYPE_TIMESTAMP = 180;
    public static final int DB_TYPE_TIMESTAMPTZ = 181;
    public static final int DB_TYPE_INTERVALYM = 182;
    public static final int DB_TYPE_INTERVALDS = 183;
    public static final int DB_TYPE_UROWID = 208;
    public static final int DB_TYPE_TIMESTAMPLTZ = 231;
    public static final int DB_CHARSET_FORM_NCHAR = 2;
    public static final int DB_TYPE_OPAQUE = 58;
    public static final int DB_TYPE_IREF = 111;
    public static final int DB_TYPE_ADT = 121;
    public static final int DB_TYPE_NESTEDTAB = 122;
    public static final int DB_TYPE_VARRAY = 123;
    public static final Map<Integer, Integer> dbTypeToOracleTypeMap = new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 1L;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        {
            this.put(1, 12);
            this.put(2, 2);
            this.put(8, -1);
            this.put(12, 91);
            this.put(23, -2);
            this.put(96, 1);
            this.put(100, 100);
            this.put(101, 101);
            this.put(180, 93);
            this.put(181, -101);
            this.put(182, -103);
            this.put(183, -104);
            this.put(231, -102);
            this.put(112, 2005);
            this.put(113, 2004);
            this.put(69, -8);
            this.put(208, -8);
            this.put(6, 2);
            this.put(21, 6);
            this.put(119, 2016);
        }

        static {
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }
    };

    public static Metadata getMetadata(String string, String string2, Connection connection) throws DBMetadataException {
        return new MetadataImpl(connection, string2, string);
    }

    public Table getTable();

    public NLSContext getNLSContext();

    public static interface TemplateSubPartition
    extends TablePartitionInfo {
        public int getBaseObjnum();

        public int getSpartPos();

        public String getSpartName();

        public int getFlags();

        public int getHiboundLen();

        public String getHiboundVal();

        @Override
        public byte[] getbHiboundVal();

        @Override
        public int getPartitionNum();

        @Override
        public boolean isDEFAULT();

        @Override
        public boolean isPartitionStaticallyDefined();

        public Collection<LobTemplateSubpartition> getTemplateLobs();
    }

    public static interface TableSubPartition
    extends TablePartitionInfo {
        public boolean isParentSubpartsItem();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        public int getBlockSize();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        public int getSubpartNum();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        public String[] getHiboundVals();

        @Override
        public byte[] getbHiboundVal();

        public int getFlags();

        public int getPctfree();

        public Collection<Lob> getLobs();

        @Override
        public boolean isDEFAULT();

        @Override
        public boolean isPartitionStaticallyDefined();
    }

    public static interface TablePartitionInfo {
        public int getPartitionNum();

        public byte[] getbHiboundVal();

        public boolean isDEFAULT();

        public boolean isPartitionStaticallyDefined();
    }

    public static interface TablePartition
    extends TablePartitionInfo {
        public boolean isParentPartListItem();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        public int getBlockSize();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        public int getFlags();

        public Collection<Lob> getLobs();

        @Override
        public boolean isPartitionStaticallyDefined();

        public String[] getHiboundVals();

        @Override
        public byte[] getbHiboundVal();

        public int getPctfree();

        @Override
        public boolean isDEFAULT();
    }

    public static interface TableCompositePartition
    extends TablePartitionInfo {
        public boolean isParentCompartListItem();

        public boolean isParentSubparts();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        @Override
        public byte[] getbHiboundVal();

        public int getSubpartCount();

        public int getSmatchTPL();

        public Collection<TableSubPartition> getSubpartitionsObj();

        public Collection<LobPartition> getLobPartitions();

        public int getLmatchTPL();

        public int getFlags();

        public int getDefpctfree();

        public long getSpare2();

        public boolean isDirpathCompressionEnabled();

        public Collection<TablePartitionInfo> getSubpartitions();

        public String getSubPartitionName(int var1);

        @Override
        public boolean isPartitionStaticallyDefined();
    }

    public static interface Table {
        public boolean isPartitioned();

        public PartitionType getPartitionType();

        public boolean isCompositePartition();

        public boolean isIntervalPartition();

        public PartitionType getSubpartitionType();

        public List<ColumnMetadata> getPartitionKeyColumnsMetadata();

        public int getPartitionCount();

        public List<ColumnMetadata> getSubpartitionColumns();

        public Collection<TablePartitionInfo> getPartitions();

        public String getPartitionName(int var1);

        public String getSubPartitionName(int var1, int var2);

        public Collection<TablePartitionInfo> getCompositePartitions();

        public Collection<TablePartitionInfo> getTemplateSubPartitions();

        public int getColumnCount();

        public String getName();

        public String getSchemaQualifiedName();

        public Collection<ColumnMetadata> getColumns();

        public ColumnMetadata getColumn(int var1);

        public ColumnMetadata getColumn(String var1);

        public Partition getPartitionObj();

        public Vector<Constraint> getConstraints();

        public boolean hasConstraints();

        public boolean hasPrimaryConstraint();

        public Constraint getPrimaryConstraint();

        public Collection<ColumnMetadata> getPrimaryConstraintColumnsMetadata();

        public String[] getPrimaryConstraintColumns();

        public Collection<Constraint> getUniqueConstraints();

        public Collection<ColumnMetadata> getConstraintColumns(Constraint var1);

        public byte[] getIntervalBinaryValue();

        public int getIntervalDataType();

        public int getDefSubpartitionCount();
    }

    public static interface StreamColumn {
        public String getName();

        public int getColNum();
    }

    public static interface Storage {
        public long getFlags();

        public CompressionType getCompressionType();
    }

    public static interface SimpleColumn {
        public int getColumnNum();

        public int getProperty();

        public String getName();

        public int getTypeNum();
    }

    public static interface Schema {
        public Timestamp createTimestamp(String var1);

        public boolean isTable();

        public boolean isTablePartition();

        public boolean isTableSubPartition();

        public boolean isLOB();

        public boolean isLOBPartition();

        public boolean isLOBSubPartition();

        public int getObjNum();

        public int getOwnerNum();

        public String getOwnerName();

        public String getName();

        public int getTypeNum();

        public SchemaType getType();

        public String getTypeName();

        public Timestamp getCreationTime();

        public Timestamp getDDLModificationTime();

        public Timestamp getSpecTime();

        public String getSubName();
    }

    public static interface PartitionColumn {
        public SimpleColumn getColumn();

        public int getPositionNum();
    }

    public static interface Partition {
        public BasePartition getBasePartition();

        public Collection<PartitionColumn> getPartitionColumns();

        public Collection<PartitionColumn> getSubpartitionColumns();

        public Collection<TablePartition> getPartitions();

        public Collection<TableCompositePartition> getCompositePartitions();

        public Collection<TemplateSubPartition> getTemplateSubPartitions();

        public PartitionType getPartitionType();

        public PartitionType getSubpartitionType();

        public int getPartType();

        public boolean isCompositePartition();

        public boolean isIntervalPartition();

        public int getSubpartType();

        public int getDefSubpartitionCount();
    }

    public static interface LobTemplateSubpartition {
        public int getBaseObjnum();

        public String getColName();

        public int getIntColNum();

        public int getSubpartPos();

        public int getFlags();

        public String getLobSpartName();

        public String getTablespaceName();

        public int getTablespaceNum();
    }

    public static interface LobPartition {
        public boolean hasPartNum();

        public int getPartNum();

        public Schema getSchema();

        public String getDefaultTablespaceName();

        public int getDefaultBlocksize();

        public int getDefaultChunk();

        public int getDefaultPctVersion();

        public int getDefaultFlags();

        public int getDefaultPartitionProperty();

        public int getDefaultIntialExtentSize();

        public int getDefaultNextExtentSize();

        public int getDefaultMinExtents();

        public int getDefaultMaxExtents();

        public int getDefaultPctIncrease();

        public int getDefaultFreelists();

        public int getDefaultFreelistGroups();

        public int getDefaultBufferPool();

        public int getSpare1();

        public int getSpare2();

        public int getSpare3();

        public int getDefaultMaxSize();

        public int getDefaultRetention();

        public int getDefaultMinRetentionTime();
    }

    public static interface Lob {
        public int getPartNum();

        public int getColNum();

        public Schema getSchema();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        public String getTablespaceName();

        public int getBlocksize();

        public int getChunk();

        public int getPctVersion();

        public int getFlags();

        public int getProperty();

        public int getRetentionTime();

        public int getFreepools();

        public int getSpare1();

        public int getSpare2();

        public String getSpare3();

        public int getSpare3Num();

        public boolean isPartitioned();
    }

    public static interface DeferredStorage {
        public int getPctfree();

        public int getFlags();

        public int getCmpFlag();

        public int getCmpLvl();

        public CompressionType getCompressionType();
    }

    public static interface ConstraintColumn {
        public int getConstraintNum();

        public int getPositionNum();

        public int getOidOrSetid();

        public SimpleColumn getColumn();
    }

    public static interface Constraint {
        public boolean isPrimary();

        public boolean isUnique();

        public ConstraintType getType();

        public Vector<ConstraintColumn> getColumns();
    }

    public static interface BasePartition {
        public boolean isIntervalPartition();

        public boolean isCompositePartition();

        public boolean isDirpathCompressionEnabled();

        public PartitionType getPartitionType();

        public PartitionType getSubpartitionType();

        public int getPartType();

        public int getPartitionCount();

        public int getPartitionKeyColumnsNum();

        public int getFlags();

        public long getSpare2();

        public int getSubpartType();

        public int getDefSubpartitionCount();

        public int getSpare3();

        public String getIntervalString();

        public byte[] getIntervalBinaryValue();
    }

    public static interface ColumnMetadata {
        public int getColumnNum();

        public String getName();

        public int getTypeNum();

        public SQLType getSQLType();

        public int getLength();

        public int getPrecisionNum();

        public int getScale();

        public boolean isNotNull();

        public int getCharsetId();

        public int getCharsetForm();

        public int getCharLength();

        public int getPrecision();

        public boolean isLoadTarget();

        public boolean isVirtualColumn();

        public boolean isCharType();

        public boolean isFloatType();

        public boolean isNumberType();

        public boolean isCharacterType();

        public boolean isBinaryType();

        public boolean isDateTimeType();

        public boolean isIntervalType();

        public boolean isNChar();

        public boolean isLobType();

        public boolean isLob();

        public boolean isBlob();

        public boolean isClob();

        public boolean isNClob();

        public boolean hasPrecision();

        public boolean hasScale();

        public boolean isColumnLengthInChars();

        public int getSpare3();

        public int getSegmentColumnNum();

        public void setLoadTarget(boolean var1);

        public String createDDL(boolean var1);

        public void setInputFormat(String var1);

        public String getInputFormat();
    }

    public static final class NLSContext {
        public static final int CHAR_FORM_OF_USE = 1;
        public static final int NCHAR_FORM_OF_USE = 2;
        public static final String LOCAL_TIMEZONE = "LOCAL";
        private static final Date TWO_DIGIT_YEAR_START;
        private static final String DEFAULT_ORA_DATE_FORMAT = "SYYYY-MM-DD HH24:MI:SS";
        private static final String ORA_TIMESTAMP_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF";
        private static final String ORA_TIMESTAMP_TZR_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF TZR";
        private static final String ORA_TIMESTAMP_TZH_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
        private Map<String, String> dbProperties;
        private final GregorianCalendar dbCalendar;
        private static GregorianCalendar sessionCalendar;
        private static Map<String, DateFormat> javaDateFormats;
        private final byte[] padBytes;
        private final byte[] nPadBytes;
        private static final Object tzLock;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;

        public NLSContext(Map<String, String> map) {
            int n;
            this.dbProperties = map;
            CharacterSet characterSet = null;
            CharacterSet characterSet2 = null;
            String string = this.getDatabaseProperty(DBProperty.NLS_CHARACTERSET_ID);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    characterSet = NLSContext.getCharacterSet(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string = this.getDatabaseProperty(DBProperty.NLS_NCHAR_CHARACTERSET_ID)) != null) {
                try {
                    n = Integer.parseInt(string);
                    characterSet2 = NLSContext.getCharacterSet(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string2 = this.getDatabaseProperty(DBProperty.DBTIMEZONE);
            this.dbCalendar = new GregorianCalendar(NLSContext.getTimeZone(string2));
            this.dbCalendar.setLenient(false);
            this.padBytes = this.getPadBytes(DBProperty.CHAR_PAD, characterSet);
            this.nPadBytes = this.getPadBytes(DBProperty.NCHAR_PAD, characterSet2);
        }

        public static CharacterSet getCharacterSet(int n) {
            CharacterSet characterSet = CharacterSet.make((int)n);
            if (characterSet.getOracleId() != n) {
                characterSet = null;
            }
            return characterSet;
        }

        public GregorianCalendar getDatabaseCalendar() {
            return (GregorianCalendar)this.dbCalendar.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static GregorianCalendar getSessionCalendar() {
            Object object = tzLock;
            synchronized (object) {
                return (GregorianCalendar)sessionCalendar.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSessionTimezone(TimeZone timeZone) {
            Object object = tzLock;
            synchronized (object) {
                sessionCalendar = new GregorianCalendar(timeZone);
                sessionCalendar.setLenient(false);
            }
        }

        public String getDatabaseDateTimeFormatPattern() {
            return DEFAULT_ORA_DATE_FORMAT;
        }

        public static String getDatabaseTimestampFormat() {
            return ORA_TIMESTAMP_FORMAT;
        }

        public static String getDatabaseTimestampTZFormat() {
            if (ZONEIDMAP.isValidRegion((String)sessionCalendar.getTimeZone().getID())) {
                return ORA_TIMESTAMP_TZR_FORMAT;
            }
            return ORA_TIMESTAMP_TZH_FORMAT;
        }

        public String getDatabaseProperty(DBProperty dBProperty) {
            return this.dbProperties.get(dBProperty.toString());
        }

        public static DateFormat getJavaDateFormat(String string2) {
            return (DateFormat)javaDateFormats.computeIfAbsent(string2, string -> NLSContext.create(string)).clone();
        }

        private static DateFormat create(String string) {
            String string2 = string == null ? "" : string;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            simpleDateFormat.set2DigitYearStart(TWO_DIGIT_YEAR_START);
            return simpleDateFormat;
        }

        public static TimeZone getTimeZone(String string) throws IllegalArgumentException {
            TimeZone timeZone;
            String string2;
            String string3 = string2 = string != null ? string.trim() : "";
            if (string2.equalsIgnoreCase(LOCAL_TIMEZONE)) {
                return TimeZone.getDefault();
            }
            Object object = "";
            if (string2.length() > 0) {
                char c = string2.charAt(0);
                object = c == '+' || c == '-' ? "GMT" + string2 : ("00:00".compareTo(string) == 0 || "0:00".compareTo(string) == 0 ? "GMT+00:00" : string2);
            }
            if (0 != (timeZone = TimeZone.getTimeZone((String)object)).getID().compareTo((String)object)) {
                throw new IllegalArgumentException("Invalid timezone");
            }
            return timeZone;
        }

        public byte[] getPadBytes() {
            return this.padBytes;
        }

        public byte[] getNpadBytes() {
            return this.nPadBytes;
        }

        public byte[] padToLength(byte[] byArray, int n, int n2, int n3, int n4) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byte[] byArray3 = n4 == 1 ? this.getPadBytes() : this.getNpadBytes();
            int n5 = n2 - byArray.length;
            int n6 = n5 / byArray3.length;
            n6 = Math.min(n6, n3 - n);
            int n7 = byArray.length;
            for (int i = 0; i < n6 && n7 < byArray2.length; n7 += byArray3.length, ++i) {
                System.arraycopy(byArray3, 0, byArray2, n7, byArray3.length);
            }
            return byArray2;
        }

        public byte[] unpad(byte[] byArray, int n) {
            int n2 = this.getNumBytesOfPadding(byArray, n);
            int n3 = byArray.length - n2;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }

        public int getNumBytesOfPadding(byte[] byArray, int n) {
            int n2;
            byte[] byArray2 = n == 1 ? this.getPadBytes() : this.getNpadBytes();
            int n3 = 0;
            int n4 = byArray2.length;
            for (n2 = byArray.length - 1; n2 >= 0; --n2) {
                if (byArray[n2] != byArray2[--n4]) {
                    n3 = n2 + byArray2.length - n4;
                    break;
                }
                if (n4 != 0) continue;
                n4 = byArray2.length;
            }
            n2 = byArray.length - n3;
            return n2;
        }

        private byte[] getPadBytes(DBProperty dBProperty, CharacterSet characterSet) {
            byte[] byArray;
            String string = this.getDatabaseProperty(dBProperty);
            if (string == null) {
                try {
                    byArray = characterSet.convert(" ");
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(dBProperty + " convert failure", sQLException);
                }
            } else {
                String[] stringArray = string.split(",", -1);
                byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    byArray[i] = Byte.parseByte(stringArray[i]);
                }
            }
            return byArray;
        }

        static {
            try {
                $$$methodRef$$$18 = NLSContext.class.getDeclaredConstructor(Map.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$17 = NLSContext.class.getDeclaredMethod("lambda$getJavaDateFormat$0", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$16 = NLSContext.class.getDeclaredMethod("getPadBytes", DBProperty.class, CharacterSet.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$15 = NLSContext.class.getDeclaredMethod("getNumBytesOfPadding", byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$14 = NLSContext.class.getDeclaredMethod("unpad", byte[].class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$13 = NLSContext.class.getDeclaredMethod("padToLength", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$12 = NLSContext.class.getDeclaredMethod("getNpadBytes", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$11 = NLSContext.class.getDeclaredMethod("getPadBytes", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$10 = NLSContext.class.getDeclaredMethod("getTimeZone", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$9 = NLSContext.class.getDeclaredMethod("create", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$8 = NLSContext.class.getDeclaredMethod("getJavaDateFormat", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$7 = NLSContext.class.getDeclaredMethod("getDatabaseProperty", DBProperty.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$6 = NLSContext.class.getDeclaredMethod("getDatabaseTimestampTZFormat", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$5 = NLSContext.class.getDeclaredMethod("getDatabaseTimestampFormat", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$4 = NLSContext.class.getDeclaredMethod("getDatabaseDateTimeFormatPattern", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = NLSContext.class.getDeclaredMethod("setSessionTimezone", TimeZone.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = NLSContext.class.getDeclaredMethod("getSessionCalendar", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = NLSContext.class.getDeclaredMethod("getDatabaseCalendar", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = NLSContext.class.getDeclaredMethod("getCharacterSet", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            TWO_DIGIT_YEAR_START = new Date("Sat, 01 Jan 2000 00:00:00 GMT");
            javaDateFormats = new ConcurrentHashMap<String, DateFormat>();
            sessionCalendar = new GregorianCalendar();
            sessionCalendar.setLenient(false);
            tzLock = new Object();
        }
    }

    public static class DBMetadataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final CODE code;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public DBMetadataException(CODE cODE, String string, Throwable throwable) {
            super(string);
            this.code = cODE;
            this.initCause(throwable);
        }

        public DBMetadataException(CODE cODE, String string) {
            super(string);
            this.code = cODE;
        }

        public DBMetadataException() {
            this.code = CODE.INTERNAL;
        }

        public CODE getCode() {
            return this.code;
        }

        static {
            try {
                $$$methodRef$$$3 = DBMetadataException.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = DBMetadataException.class.getDeclaredConstructor(CODE.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = DBMetadataException.class.getDeclaredConstructor(CODE.class, String.class, Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = DBMetadataException.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        }

        public static final class CODE
        extends Enum<CODE> {
            public static final /* enum */ CODE TABLE_CONFIG;
            public static final /* enum */ CODE IO_ERROR;
            public static final /* enum */ CODE GENERIC;
            public static final /* enum */ CODE INTERNAL;
            public static final /* enum */ CODE PART_KEY_NOT_FOUND;
            public static final /* enum */ CODE PART_MAX_PARTITION_EXCEEDED;
            public static final /* enum */ CODE PART_TOTAL_SUBPART_EXCEEDS_MAX;
            public static final /* enum */ CODE PART_ERROR;
            public static final /* enum */ CODE JDBC_ERROR;
            public static final /* enum */ CODE PARSE_ERROR;
            public static final /* enum */ CODE PARSE_ERROR_CONSTRAINT;
            public static final /* enum */ CODE PARSE_ERROR_UNSUPPORTED_TYPE;
            public static final /* enum */ CODE INVALID_PARTITION_FILE;
            private static final /* synthetic */ CODE[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            public static CODE[] values() {
                return (CODE[])$VALUES.clone();
            }

            public static CODE valueOf(String string) {
                return Enum.valueOf(CODE.class, string);
            }

            static {
                try {
                    $$$methodRef$$$2 = CODE.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$1 = CODE.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                try {
                    $$$methodRef$$$0 = CODE.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
                TABLE_CONFIG = new CODE();
                IO_ERROR = new CODE();
                GENERIC = new CODE();
                INTERNAL = new CODE();
                PART_KEY_NOT_FOUND = new CODE();
                PART_MAX_PARTITION_EXCEEDED = new CODE();
                PART_TOTAL_SUBPART_EXCEEDS_MAX = new CODE();
                PART_ERROR = new CODE();
                JDBC_ERROR = new CODE();
                PARSE_ERROR = new CODE();
                PARSE_ERROR_CONSTRAINT = new CODE();
                PARSE_ERROR_UNSUPPORTED_TYPE = new CODE();
                INVALID_PARTITION_FILE = new CODE();
                $VALUES = new CODE[]{TABLE_CONFIG, IO_ERROR, GENERIC, INTERNAL, PART_KEY_NOT_FOUND, PART_MAX_PARTITION_EXCEEDED, PART_TOTAL_SUBPART_EXCEEDS_MAX, PART_ERROR, JDBC_ERROR, PARSE_ERROR, PARSE_ERROR_CONSTRAINT, PARSE_ERROR_UNSUPPORTED_TYPE, INVALID_PARTITION_FILE};
            }
        }
    }

    public static final class CompressionType
    extends Enum<CompressionType> {
        public static final /* enum */ CompressionType NONE;
        public static final /* enum */ CompressionType BASIC;
        public static final /* enum */ CompressionType OLTP;
        public static final /* enum */ CompressionType QUERY_LOW;
        public static final /* enum */ CompressionType QUERY_HIGH;
        public static final /* enum */ CompressionType ARCHIVE_LOW;
        public static final /* enum */ CompressionType ARCHIVE_HIGH;
        private static final /* synthetic */ CompressionType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static CompressionType[] values() {
            return (CompressionType[])$VALUES.clone();
        }

        public static CompressionType valueOf(String string) {
            return Enum.valueOf(CompressionType.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = CompressionType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = CompressionType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = CompressionType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            NONE = new CompressionType();
            BASIC = new CompressionType();
            OLTP = new CompressionType();
            QUERY_LOW = new CompressionType();
            QUERY_HIGH = new CompressionType();
            ARCHIVE_LOW = new CompressionType();
            ARCHIVE_HIGH = new CompressionType();
            $VALUES = new CompressionType[]{NONE, BASIC, OLTP, QUERY_LOW, QUERY_HIGH, ARCHIVE_LOW, ARCHIVE_HIGH};
        }
    }

    public static final class SchemaType
    extends Enum<SchemaType> {
        public static final /* enum */ SchemaType TABLE;
        public static final /* enum */ SchemaType TABLE_PARTITION;
        public static final /* enum */ SchemaType TABLE_SUBPARTITION;
        public static final /* enum */ SchemaType LOB;
        public static final /* enum */ SchemaType LOB_PARTITION;
        public static final /* enum */ SchemaType LOB_SUBPARTITION;
        public static final /* enum */ SchemaType UNSUPPORTED;
        private static final HashMap<Integer, SchemaType> lookup;
        private int m_typecode;
        private static final /* synthetic */ SchemaType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static SchemaType[] values() {
            return (SchemaType[])$VALUES.clone();
        }

        public static SchemaType valueOf(String string) {
            return Enum.valueOf(SchemaType.class, string);
        }

        private SchemaType(int n2) {
            this.m_typecode = n2;
        }

        public int getType() {
            return this.m_typecode;
        }

        public static SchemaType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            try {
                $$$methodRef$$$4 = SchemaType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = SchemaType.class.getDeclaredMethod("getName", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = SchemaType.class.getDeclaredMethod("getType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = SchemaType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = SchemaType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            TABLE = new SchemaType(2);
            TABLE_PARTITION = new SchemaType(19);
            TABLE_SUBPARTITION = new SchemaType(34);
            LOB = new SchemaType(21);
            LOB_PARTITION = new SchemaType(40);
            LOB_SUBPARTITION = new SchemaType(41);
            UNSUPPORTED = new SchemaType(0);
            $VALUES = new SchemaType[]{TABLE, TABLE_PARTITION, TABLE_SUBPARTITION, LOB, LOB_PARTITION, LOB_SUBPARTITION, UNSUPPORTED};
            lookup = new HashMap();
            for (SchemaType schemaType : EnumSet.allOf(SchemaType.class)) {
                lookup.put(schemaType.getType(), schemaType);
            }
        }
    }

    public static final class PartitionType
    extends Enum<PartitionType> {
        public static final /* enum */ PartitionType RANGE;
        public static final /* enum */ PartitionType HASH;
        public static final /* enum */ PartitionType LIST;
        public static final /* enum */ PartitionType UNSUPPORTED;
        private static final HashMap<Integer, PartitionType> lookup;
        private int part_type;
        private static final /* synthetic */ PartitionType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static PartitionType[] values() {
            return (PartitionType[])$VALUES.clone();
        }

        public static PartitionType valueOf(String string) {
            return Enum.valueOf(PartitionType.class, string);
        }

        private PartitionType(int n2) {
            this.part_type = n2;
        }

        public int getType() {
            return this.part_type;
        }

        public static PartitionType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            try {
                $$$methodRef$$$4 = PartitionType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = PartitionType.class.getDeclaredMethod("getName", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = PartitionType.class.getDeclaredMethod("getType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = PartitionType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = PartitionType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            RANGE = new PartitionType(1);
            HASH = new PartitionType(2);
            LIST = new PartitionType(4);
            UNSUPPORTED = new PartitionType(0);
            $VALUES = new PartitionType[]{RANGE, HASH, LIST, UNSUPPORTED};
            lookup = new HashMap();
            for (PartitionType partitionType : EnumSet.allOf(PartitionType.class)) {
                lookup.put(partitionType.getType(), partitionType);
            }
        }
    }

    public static final class DBProperty
    extends Enum<DBProperty> {
        public static final /* enum */ DBProperty DBTIMEZONE;
        public static final /* enum */ DBProperty NLS_CALENDAR;
        public static final /* enum */ DBProperty NLS_CHARACTERSET;
        public static final /* enum */ DBProperty NLS_CHARACTERSET_ID;
        public static final /* enum */ DBProperty NLS_COMP;
        public static final /* enum */ DBProperty NLS_CURRENCY;
        public static final /* enum */ DBProperty NLS_DATE_FORMAT;
        public static final /* enum */ DBProperty NLS_DATE_LANGUAGE;
        public static final /* enum */ DBProperty NLS_DUAL_CURRENCY;
        public static final /* enum */ DBProperty NLS_ISO_CURRENCY;
        public static final /* enum */ DBProperty NLS_LANGUAGE;
        public static final /* enum */ DBProperty NLS_LENGTH_SEMANTICS;
        public static final /* enum */ DBProperty NLS_NCHAR_CHARACTERSET;
        public static final /* enum */ DBProperty NLS_NCHAR_CHARACTERSET_ID;
        public static final /* enum */ DBProperty NLS_NCHAR_CONV_EXCP;
        public static final /* enum */ DBProperty NLS_NUMERIC_CHARACTERS;
        public static final /* enum */ DBProperty NLS_RDBMS_VERSION;
        public static final /* enum */ DBProperty NLS_SORT;
        public static final /* enum */ DBProperty NLS_TERRITORY;
        public static final /* enum */ DBProperty NLS_TIMESTAMP_FORMAT;
        public static final /* enum */ DBProperty NLS_TIMESTAMP_TZ_FORMAT;
        public static final /* enum */ DBProperty NLS_TIME_FORMAT;
        public static final /* enum */ DBProperty NLS_TIME_TZ_FORMAT;
        public static final /* enum */ DBProperty CHAR_PAD;
        public static final /* enum */ DBProperty NCHAR_PAD;
        public static final /* enum */ DBProperty PORT_STRING;
        private static final /* synthetic */ DBProperty[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static DBProperty[] values() {
            return (DBProperty[])$VALUES.clone();
        }

        public static DBProperty valueOf(String string) {
            return Enum.valueOf(DBProperty.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = DBProperty.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = DBProperty.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = DBProperty.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            DBTIMEZONE = new DBProperty();
            NLS_CALENDAR = new DBProperty();
            NLS_CHARACTERSET = new DBProperty();
            NLS_CHARACTERSET_ID = new DBProperty();
            NLS_COMP = new DBProperty();
            NLS_CURRENCY = new DBProperty();
            NLS_DATE_FORMAT = new DBProperty();
            NLS_DATE_LANGUAGE = new DBProperty();
            NLS_DUAL_CURRENCY = new DBProperty();
            NLS_ISO_CURRENCY = new DBProperty();
            NLS_LANGUAGE = new DBProperty();
            NLS_LENGTH_SEMANTICS = new DBProperty();
            NLS_NCHAR_CHARACTERSET = new DBProperty();
            NLS_NCHAR_CHARACTERSET_ID = new DBProperty();
            NLS_NCHAR_CONV_EXCP = new DBProperty();
            NLS_NUMERIC_CHARACTERS = new DBProperty();
            NLS_RDBMS_VERSION = new DBProperty();
            NLS_SORT = new DBProperty();
            NLS_TERRITORY = new DBProperty();
            NLS_TIMESTAMP_FORMAT = new DBProperty();
            NLS_TIMESTAMP_TZ_FORMAT = new DBProperty();
            NLS_TIME_FORMAT = new DBProperty();
            NLS_TIME_TZ_FORMAT = new DBProperty();
            CHAR_PAD = new DBProperty();
            NCHAR_PAD = new DBProperty();
            PORT_STRING = new DBProperty();
            $VALUES = new DBProperty[]{DBTIMEZONE, NLS_CALENDAR, NLS_CHARACTERSET, NLS_CHARACTERSET_ID, NLS_COMP, NLS_CURRENCY, NLS_DATE_FORMAT, NLS_DATE_LANGUAGE, NLS_DUAL_CURRENCY, NLS_ISO_CURRENCY, NLS_LANGUAGE, NLS_LENGTH_SEMANTICS, NLS_NCHAR_CHARACTERSET, NLS_NCHAR_CHARACTERSET_ID, NLS_NCHAR_CONV_EXCP, NLS_NUMERIC_CHARACTERS, NLS_RDBMS_VERSION, NLS_SORT, NLS_TERRITORY, NLS_TIMESTAMP_FORMAT, NLS_TIMESTAMP_TZ_FORMAT, NLS_TIME_FORMAT, NLS_TIME_TZ_FORMAT, CHAR_PAD, NCHAR_PAD, PORT_STRING};
        }
    }

    public static final class ConstraintType
    extends Enum<ConstraintType> {
        public static final /* enum */ ConstraintType PRIMARY;
        public static final /* enum */ ConstraintType UNIQUE;
        public static final /* enum */ ConstraintType NOTNULL;
        public static final /* enum */ ConstraintType UNSUPPORTED;
        private static final HashMap<Integer, ConstraintType> lookup;
        private final int m_typecode;
        private static final /* synthetic */ ConstraintType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static ConstraintType[] values() {
            return (ConstraintType[])$VALUES.clone();
        }

        public static ConstraintType valueOf(String string) {
            return Enum.valueOf(ConstraintType.class, string);
        }

        private ConstraintType(int n2) {
            this.m_typecode = n2;
        }

        public int getTypecode() {
            return this.m_typecode;
        }

        public static ConstraintType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            try {
                $$$methodRef$$$4 = ConstraintType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = ConstraintType.class.getDeclaredMethod("getName", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ConstraintType.class.getDeclaredMethod("getTypecode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ConstraintType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ConstraintType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            PRIMARY = new ConstraintType(2);
            UNIQUE = new ConstraintType(3);
            NOTNULL = new ConstraintType(7);
            UNSUPPORTED = new ConstraintType(0);
            $VALUES = new ConstraintType[]{PRIMARY, UNIQUE, NOTNULL, UNSUPPORTED};
            lookup = new HashMap();
            for (ConstraintType constraintType : EnumSet.allOf(ConstraintType.class)) {
                lookup.put(constraintType.getTypecode(), constraintType);
            }
        }
    }

    public static final class ObjectColumnType
    extends Enum<ObjectColumnType> {
        public static final /* enum */ ObjectColumnType ADT;
        public static final /* enum */ ObjectColumnType NESTEDTAB;
        public static final /* enum */ ObjectColumnType VARRAY;
        public static final /* enum */ ObjectColumnType IREF;
        public static final /* enum */ ObjectColumnType OPAQUE;
        private static final HashMap<Integer, ObjectColumnType> lookup;
        private int type_num;
        private static final /* synthetic */ ObjectColumnType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static ObjectColumnType[] values() {
            return (ObjectColumnType[])$VALUES.clone();
        }

        public static ObjectColumnType valueOf(String string) {
            return Enum.valueOf(ObjectColumnType.class, string);
        }

        private ObjectColumnType(int n2) {
            this.type_num = n2;
        }

        public int getTypeNum() {
            return this.type_num;
        }

        public static boolean isObjCol(int n) {
            try {
                return lookup.containsKey(n);
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        static {
            try {
                $$$methodRef$$$4 = ObjectColumnType.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$3 = ObjectColumnType.class.getDeclaredMethod("isObjCol", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$2 = ObjectColumnType.class.getDeclaredMethod("getTypeNum", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = ObjectColumnType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = ObjectColumnType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            ADT = new ObjectColumnType(121);
            NESTEDTAB = new ObjectColumnType(122);
            VARRAY = new ObjectColumnType(123);
            IREF = new ObjectColumnType(111);
            OPAQUE = new ObjectColumnType(58);
            $VALUES = new ObjectColumnType[]{ADT, NESTEDTAB, VARRAY, IREF, OPAQUE};
            lookup = new HashMap();
            for (ObjectColumnType objectColumnType : EnumSet.allOf(ObjectColumnType.class)) {
                lookup.put(objectColumnType.getTypeNum(), objectColumnType);
            }
        }
    }
}

