/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.util;

import com.mailgun.api.MailgunApi;
import com.mailgun.enums.ApiVersion;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.StringUtils;

public final class MailgunApiUtil {
    public static String getFullUrl(Class<? extends MailgunApi> apiType, String baseUrl) {
        MailgunApi mailgunApi = (MailgunApi)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{apiType}, (proxy, method, args) -> {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(apiType)).in(apiType).unreflectSpecial(method, apiType).bindTo(proxy).invokeWithArguments(args);
        });
        ApiVersion apiVersion = mailgunApi.getApiVersion();
        return MailgunApiUtil.getFullUrl(baseUrl, apiVersion.getValue());
    }

    private static String getFullUrl(String baseUrl, String apiVersion) {
        return StringUtils.endsWith((CharSequence)baseUrl, (CharSequence)"/") ? baseUrl + apiVersion : baseUrl + "/" + apiVersion;
    }

    private MailgunApiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

