/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jcajce.provider.asymmetric.dsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.asn1.x509.X509ObjectIdentifiers;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.DSA;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.NullDigest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA224Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.digests.SHA384Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.ParametersWithRandom;
import org.spongycastle.crypto.signers.DSAKCalculator;
import org.spongycastle.crypto.signers.HMacDSAKCalculator;
import org.spongycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import org.spongycastle.jcajce.provider.asymmetric.dsa.DSAUtil;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected DSASigner(Digest digest, DSA signer) {
        this.digest = digest;
        this.signer = signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof DSAKey) {
            param = DSAUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = new BCDSAPublicKey(SubjectPublicKeyInfo.getInstance((Object)bytes));
                if (!(publicKey instanceof DSAKey)) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                param = DSAUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in DSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, (CipherParameters)param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter param = DSAUtil.generatePrivateKeyParameter(privateKey);
        if (this.random != null) {
            param = new ParametersWithRandom((CipherParameters)param, this.random);
        }
        this.digest.reset();
        this.signer.init(true, (CipherParameters)param);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            BigInteger[] sig = this.signer.generateSignature(hash);
            return this.derEncode(sig[0], sig[1]);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger[] sig;
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        try {
            sig = this.derDecode(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(hash, sig[0], sig[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1Integer[] rs = new ASN1Integer[]{new ASN1Integer(r), new ASN1Integer(s)};
        return new DERSequence((ASN1Encodable[])rs).getEncoded("DER");
    }

    private BigInteger[] derDecode(byte[] encoding) throws IOException {
        ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])encoding);
        return new BigInteger[]{((ASN1Integer)s.getObjectAt(0)).getValue(), ((ASN1Integer)s.getObjectAt(1)).getValue()};
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            super((Digest)new NullDigest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }

    public static class detDSA512
    extends DSASigner {
        public detDSA512() {
            super((Digest)new SHA512Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA512Digest())));
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            super((Digest)new SHA512Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }

    public static class detDSA384
    extends DSASigner {
        public detDSA384() {
            super((Digest)new SHA384Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA384Digest())));
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            super((Digest)new SHA384Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }

    public static class detDSA256
    extends DSASigner {
        public detDSA256() {
            super((Digest)new SHA256Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest())));
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            super((Digest)new SHA256Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }

    public static class detDSA224
    extends DSASigner {
        public detDSA224() {
            super((Digest)new SHA224Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA224Digest())));
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            super((Digest)new SHA224Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }

    public static class detDSA
    extends DSASigner {
        public detDSA() {
            super((Digest)new SHA1Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA1Digest())));
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            super((Digest)new SHA1Digest(), (DSA)new org.spongycastle.crypto.signers.DSASigner());
        }
    }
}

