/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.spongycastle.asn1.cms.RecipientEncryptedKey;
import org.spongycastle.asn1.cms.RecipientKeyIdentifier;
import org.spongycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.cms.CMSAlgorithm;
import org.spongycastle.cms.CMSEnvelopedGenerator;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.KeyAgreeRecipientInfoGenerator;
import org.spongycastle.cms.jcajce.CMSUtils;
import org.spongycastle.cms.jcajce.DefaultJcaJceExtHelper;
import org.spongycastle.cms.jcajce.EnvelopedDataHelper;
import org.spongycastle.cms.jcajce.NamedJcaJceExtHelper;
import org.spongycastle.cms.jcajce.ProviderJcaJceExtHelper;
import org.spongycastle.jce.spec.MQVPrivateKeySpec;
import org.spongycastle.jce.spec.MQVPublicKeySpec;
import org.spongycastle.operator.GenericKey;

public class JceKeyAgreeRecipientInfoGenerator
extends KeyAgreeRecipientInfoGenerator {
    private List recipientIDs = new ArrayList();
    private List recipientKeys = new ArrayList();
    private PublicKey senderPublicKey;
    private PrivateKey senderPrivateKey;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private KeyPair ephemeralKP;

    public JceKeyAgreeRecipientInfoGenerator(ASN1ObjectIdentifier keyAgreementOID, PrivateKey senderPrivateKey, PublicKey senderPublicKey, ASN1ObjectIdentifier keyEncryptionOID) {
        super(keyAgreementOID, SubjectPublicKeyInfo.getInstance((Object)senderPublicKey.getEncoded()), keyEncryptionOID);
        this.senderPublicKey = senderPublicKey;
        this.senderPrivateKey = senderPrivateKey;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(X509Certificate recipientCert) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(recipientCert)));
        this.recipientKeys.add(recipientCert.getPublicKey());
        return this;
    }

    public JceKeyAgreeRecipientInfoGenerator addRecipient(byte[] subjectKeyID, PublicKey publicKey) throws CertificateEncodingException {
        this.recipientIDs.add(new KeyAgreeRecipientIdentifier(new RecipientKeyIdentifier(subjectKeyID)));
        this.recipientKeys.add(publicKey);
        return this;
    }

    public ASN1Sequence generateRecipientEncryptedKeys(AlgorithmIdentifier keyAgreeAlgorithm, AlgorithmIdentifier keyEncryptionAlgorithm, GenericKey contentEncryptionKey) throws CMSException {
        this.init(keyAgreeAlgorithm.getAlgorithm());
        PrivateKey senderPrivateKey = this.senderPrivateKey;
        ASN1ObjectIdentifier keyAgreementOID = keyAgreeAlgorithm.getAlgorithm();
        if (keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            senderPrivateKey = new MQVPrivateKeySpec(senderPrivateKey, this.ephemeralKP.getPrivate(), this.ephemeralKP.getPublic());
        }
        ASN1EncodableVector recipientEncryptedKeys = new ASN1EncodableVector();
        for (int i = 0; i != this.recipientIDs.size(); ++i) {
            PublicKey recipientPublicKey = (PublicKey)this.recipientKeys.get(i);
            KeyAgreeRecipientIdentifier karId = (KeyAgreeRecipientIdentifier)this.recipientIDs.get(i);
            if (keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                recipientPublicKey = new MQVPublicKeySpec(recipientPublicKey, recipientPublicKey);
            }
            try {
                KeyAgreement keyAgreement = this.helper.createKeyAgreement(keyAgreementOID);
                keyAgreement.init((Key)senderPrivateKey, this.random);
                keyAgreement.doPhase(recipientPublicKey, true);
                SecretKey keyEncryptionKey = keyAgreement.generateSecret(keyEncryptionAlgorithm.getAlgorithm().getId());
                Cipher keyEncryptionCipher = this.helper.createCipher(keyEncryptionAlgorithm.getAlgorithm());
                keyEncryptionCipher.init(3, (Key)keyEncryptionKey, this.random);
                byte[] encryptedKeyBytes = keyEncryptionCipher.wrap(this.helper.getJceKey(contentEncryptionKey));
                DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
                recipientEncryptedKeys.add((ASN1Encodable)new RecipientEncryptedKey(karId, (ASN1OctetString)encryptedKey));
                continue;
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("cannot perform agreement step: " + e.getMessage(), e);
            }
        }
        return new DERSequence(recipientEncryptedKeys);
    }

    protected ASN1Encodable getUserKeyingMaterial(AlgorithmIdentifier keyAgreeAlg) throws CMSException {
        this.init(keyAgreeAlg.getAlgorithm());
        if (this.ephemeralKP != null) {
            return new MQVuserKeyingMaterial(this.createOriginatorPublicKey(SubjectPublicKeyInfo.getInstance((Object)this.ephemeralKP.getPublic().getEncoded())), null);
        }
        return null;
    }

    private void init(ASN1ObjectIdentifier keyAgreementOID) throws CMSException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (keyAgreementOID.equals((Object)CMSAlgorithm.ECMQV_SHA1KDF) && this.ephemeralKP == null) {
            try {
                ECParameterSpec ecParamSpec = ((ECPublicKey)this.senderPublicKey).getParams();
                KeyPairGenerator ephemKPG = this.helper.createKeyPairGenerator(keyAgreementOID);
                ephemKPG.initialize(ecParamSpec, this.random);
                this.ephemeralKP = ephemKPG.generateKeyPair();
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CMSException("cannot determine MQV ephemeral key pair parameters from public key: " + e);
            }
        }
    }
}

