/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.property.BorderCollapsePropertyValue;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;

public class CellRenderer
extends BlockRenderer {
    public CellRenderer(Cell modelElement) {
        super(modelElement);
        assert (modelElement != null);
        this.setProperty(60, modelElement.getRowspan());
        this.setProperty(16, modelElement.getColspan());
    }

    @Override
    public IPropertyContainer getModelElement() {
        return super.getModelElement();
    }

    @Override
    protected Float retrieveWidth(float parentBoxWidth) {
        return null;
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        CellRenderer splitRenderer = (CellRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        CellRenderer overflowRenderer = (CellRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return overflowRenderer;
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
        PdfCanvas canvas = drawContext.getCanvas();
        Matrix ctm = canvas.getGraphicsState().getCtm();
        Float angle = this.getPropertyAsFloat(55);
        boolean avoidRotation = null != angle && this.hasProperty(6);
        boolean restoreRotation = this.hasOwnProperty(55);
        if (avoidRotation) {
            AffineTransform transform = new AffineTransform((double)ctm.get(0), (double)ctm.get(1), (double)ctm.get(3), (double)ctm.get(4), (double)ctm.get(6), (double)ctm.get(7));
            try {
                transform = transform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new PdfException("A noninvertible matrix has been parsed. The behaviour is unpredictable.", (Throwable)e);
            }
            transform.concatenate(new AffineTransform());
            canvas.concatMatrix(transform);
            this.setProperty(55, null);
        }
        super.drawBackground(drawContext);
        if (avoidRotation) {
            if (restoreRotation) {
                this.setProperty(55, angle);
            } else {
                this.deleteOwnProperty(55);
            }
            canvas.concatMatrix(new AffineTransform((double)ctm.get(0), (double)ctm.get(1), (double)ctm.get(3), (double)ctm.get(4), (double)ctm.get(6), (double)ctm.get(7)));
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.parent.getProperty(114))) {
            super.drawBorder(drawContext);
        }
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.parent.getProperty(114))) {
            super.applyBorderBox(rect, borders, reverse);
        }
        return rect;
    }

    @Override
    protected Rectangle applyMargins(Rectangle rect, UnitValue[] margins, boolean reverse) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.parent.getProperty(114))) {
            this.applySpacings(rect, reverse);
        }
        return rect;
    }

    protected Rectangle applySpacings(Rectangle rect, boolean reverse) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.parent.getProperty(114))) {
            Float verticalBorderSpacing = (Float)this.parent.getProperty(116);
            Float horizontalBorderSpacing = (Float)this.parent.getProperty(115);
            float[] cellSpacings = new float[4];
            for (int i = 0; i < cellSpacings.length; ++i) {
                cellSpacings[i] = 0 == i % 2 ? (null != verticalBorderSpacing ? verticalBorderSpacing.floatValue() : 0.0f) : (null != horizontalBorderSpacing ? horizontalBorderSpacing.floatValue() : 0.0f);
            }
            this.applySpacings(rect, cellSpacings, reverse);
        }
        return rect;
    }

    protected Rectangle applySpacings(Rectangle rect, float[] spacings, boolean reverse) {
        if (BorderCollapsePropertyValue.SEPARATE.equals(this.parent.getProperty(114))) {
            rect.applyMargins(spacings[0] / 2.0f, spacings[1] / 2.0f, spacings[2] / 2.0f, spacings[3] / 2.0f, reverse);
        }
        return rect;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new CellRenderer((Cell)this.getModelElement());
    }
}

