/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.utils;

import com.goterl.lazysodium.LazySodium;
import java.nio.charset.Charset;
import java.util.Base64;

public class Key {
    private byte[] key;

    private Key(byte[] key) {
        this.key = key;
    }

    public byte[] getAsBytes() {
        return this.key;
    }

    public String getAsHexString() {
        return LazySodium.toHex(this.key);
    }

    public String getAsPlainString(Charset charset) {
        return new String(this.key, charset);
    }

    public String getAsPlainString() {
        return this.getAsPlainString(Charset.forName("UTF-8"));
    }

    public static Key fromHexString(String hexString) {
        return new Key(LazySodium.toBin(hexString));
    }

    public static Key fromBase64String(String base64String) {
        return new Key(Base64.getDecoder().decode(base64String));
    }

    public static Key fromPlainString(String str) {
        return new Key(str.getBytes(Charset.forName("UTF-8")));
    }

    public static Key fromPlainString(String str, Charset charset) {
        return new Key(str.getBytes(charset));
    }

    public static Key fromBytes(byte[] bytes) {
        return new Key(bytes);
    }

    public static Key generate(LazySodium ls, int size) {
        return new Key(ls.randomBytesBuf(size));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) {
            return false;
        }
        Key other = (Key)obj;
        return other.getAsHexString().equalsIgnoreCase(this.getAsHexString());
    }
}

