/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Objects;

final class ArrowType
extends JSType {
    private static final long serialVersionUID = 1L;
    final Node parameters;
    JSType returnType;
    final boolean returnTypeInferred;

    ArrowType(JSTypeRegistry registry, Node parameters, JSType returnType) {
        this(registry, parameters, returnType, false);
    }

    ArrowType(JSTypeRegistry registry, Node parameters, JSType returnType, boolean returnTypeInferred) {
        super(registry);
        this.parameters = parameters == null ? registry.createParametersWithVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) : parameters;
        this.returnType = returnType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : returnType;
        this.returnTypeInferred = returnTypeInferred;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType other, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (!(other instanceof ArrowType)) {
            return false;
        }
        ArrowType that = (ArrowType)other;
        if (!this.returnType.isSubtype(that.returnType, implicitImplCache, subtypingMode)) {
            return false;
        }
        Node thisParam = this.parameters.getFirstChild();
        Node thatParam = that.parameters.getFirstChild();
        while (thisParam != null && thatParam != null) {
            boolean thatIsOptional;
            JSType thisParamType = thisParam.getJSType();
            JSType thatParamType = thatParam.getJSType();
            if (!(thisParamType == null || thatParamType != null && thatParamType.isSubtype(thisParamType, implicitImplCache, subtypingMode))) {
                return false;
            }
            boolean thisIsVarArgs = thisParam.isVarArgs();
            boolean thatIsVarArgs = thatParam.isVarArgs();
            boolean thisIsOptional = thisIsVarArgs || thisParam.isOptionalArg();
            boolean bl = thatIsOptional = thatIsVarArgs || thatParam.isOptionalArg();
            if (!thisIsOptional && thatIsOptional) {
                boolean isTopFunction;
                boolean bl2 = isTopFunction = thatIsVarArgs && (thatParamType == null || thatParamType.isUnknownType() || thatParamType.isNoType());
                if (!isTopFunction) {
                    return false;
                }
            }
            if (!thisIsVarArgs) {
                thisParam = thisParam.getNext();
            }
            if (!thatIsVarArgs) {
                thatParam = thatParam.getNext();
            }
            if (!thisIsVarArgs || !thatIsVarArgs) continue;
            thisParam = null;
            thatParam = null;
        }
        return thisParam == null || thisParam.isOptionalArg() || thisParam.isVarArgs() || thatParam != null;
    }

    boolean hasEqualParameters(ArrowType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        Node otherParam;
        Node thisParam = this.parameters.getFirstChild();
        for (otherParam = that.parameters.getFirstChild(); thisParam != null && otherParam != null; thisParam = thisParam.getNext(), otherParam = otherParam.getNext()) {
            JSType thisParamType = thisParam.getJSType();
            JSType otherParamType = otherParam.getJSType();
            if (thisParamType != null ? otherParamType != null && !thisParamType.checkEquivalenceHelper(otherParamType, eqMethod, eqCache) : otherParamType != null) {
                return false;
            }
            if (thisParam.isOptionalArg() != otherParam.isOptionalArg()) {
                return false;
            }
            if (thisParam.isVarArgs() == otherParam.isVarArgs()) continue;
            return false;
        }
        return thisParam == otherParam;
    }

    boolean checkArrowEquivalenceHelper(ArrowType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        if (!this.returnType.checkEquivalenceHelper(that.returnType, eqMethod, eqCache)) {
            return false;
        }
        return this.hasEqualParameters(that, eqMethod, eqCache);
    }

    @Override
    int recursionUnsafeHashCode() {
        int hashCode = Objects.hashCode(this.returnType);
        if (this.parameters != null) {
            for (Node param = this.parameters.getFirstChild(); param != null; param = param.getNext()) {
                hashCode = hashCode * 31 + Objects.hashCode(param.getJSType());
            }
        }
        return hashCode;
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSType getGreatestSubtype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        this.returnType = ArrowType.safeResolve(this.returnType, reporter);
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                paramNode.setJSType(paramNode.getJSType().resolve(reporter));
            }
        }
        return this;
    }

    boolean hasUnknownParamsOrReturn() {
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                JSType type = paramNode.getJSType();
                if (type != null && !type.isUnknownType()) continue;
                return true;
            }
        }
        return this.returnType == null || this.returnType.isUnknownType();
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append("[ArrowType]");
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.returnType.hasAnyTemplateTypes() || this.hasTemplatedParameterType();
    }

    private boolean hasTemplatedParameterType() {
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                JSType type = paramNode.getJSType();
                if (type == null || !type.hasAnyTemplateTypes()) continue;
                return true;
            }
        }
        return false;
    }
}

